// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package athena

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetTableMetadataInput struct {
	_ struct{} `type:"structure"`

	// The name of the data catalog that contains the database and table metadata
	// to return.
	//
	// CatalogName is a required field
	CatalogName *string `min:"1" type:"string" required:"true"`

	// The name of the database that contains the table metadata to return.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table for which metadata is returned.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTableMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTableMetadataInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetTableMetadataInput"}

	if s.CatalogName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CatalogName"))
	}
	if s.CatalogName != nil && len(*s.CatalogName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogName", 1))
	}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetTableMetadataOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains table metadata.
	TableMetadata *TableMetadata `type:"structure"`
}

// String returns the string representation
func (s GetTableMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetTableMetadata = "GetTableMetadata"

// GetTableMetadataRequest returns a request value for making API operation for
// Amazon Athena.
//
// Returns table metadata for the specified catalog, database, and table.
//
//    // Example sending a request using GetTableMetadataRequest.
//    req := client.GetTableMetadataRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/GetTableMetadata
func (c *Client) GetTableMetadataRequest(input *GetTableMetadataInput) GetTableMetadataRequest {
	op := &aws.Operation{
		Name:       opGetTableMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTableMetadataInput{}
	}

	req := c.newRequest(op, input, &GetTableMetadataOutput{})

	return GetTableMetadataRequest{Request: req, Input: input, Copy: c.GetTableMetadataRequest}
}

// GetTableMetadataRequest is the request type for the
// GetTableMetadata API operation.
type GetTableMetadataRequest struct {
	*aws.Request
	Input *GetTableMetadataInput
	Copy  func(*GetTableMetadataInput) GetTableMetadataRequest
}

// Send marshals and sends the GetTableMetadata API request.
func (r GetTableMetadataRequest) Send(ctx context.Context) (*GetTableMetadataResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetTableMetadataResponse{
		GetTableMetadataOutput: r.Request.Data.(*GetTableMetadataOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetTableMetadataResponse is the response type for the
// GetTableMetadata API operation.
type GetTableMetadataResponse struct {
	*GetTableMetadataOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetTableMetadata request.
func (r *GetTableMetadataResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
