// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package athena

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListDatabasesInput struct {
	_ struct{} `type:"structure"`

	// The name of the data catalog that contains the databases to return.
	//
	// CatalogName is a required field
	CatalogName *string `min:"1" type:"string" required:"true"`

	// Specifies the maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDatabasesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatabasesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDatabasesInput"}

	if s.CatalogName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CatalogName"))
	}
	if s.CatalogName != nil && len(*s.CatalogName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListDatabasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of databases from a data catalog.
	DatabaseList []Database `type:"list"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDatabasesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListDatabases = "ListDatabases"

// ListDatabasesRequest returns a request value for making API operation for
// Amazon Athena.
//
// Lists the databases in the specified data catalog.
//
//    // Example sending a request using ListDatabasesRequest.
//    req := client.ListDatabasesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListDatabases
func (c *Client) ListDatabasesRequest(input *ListDatabasesInput) ListDatabasesRequest {
	op := &aws.Operation{
		Name:       opListDatabases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatabasesInput{}
	}

	req := c.newRequest(op, input, &ListDatabasesOutput{})

	return ListDatabasesRequest{Request: req, Input: input, Copy: c.ListDatabasesRequest}
}

// ListDatabasesRequest is the request type for the
// ListDatabases API operation.
type ListDatabasesRequest struct {
	*aws.Request
	Input *ListDatabasesInput
	Copy  func(*ListDatabasesInput) ListDatabasesRequest
}

// Send marshals and sends the ListDatabases API request.
func (r ListDatabasesRequest) Send(ctx context.Context) (*ListDatabasesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDatabasesResponse{
		ListDatabasesOutput: r.Request.Data.(*ListDatabasesOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListDatabasesRequestPaginator returns a paginator for ListDatabases.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListDatabasesRequest(input)
//   p := athena.NewListDatabasesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListDatabasesPaginator(req ListDatabasesRequest) ListDatabasesPaginator {
	return ListDatabasesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListDatabasesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListDatabasesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListDatabasesPaginator struct {
	aws.Pager
}

func (p *ListDatabasesPaginator) CurrentPage() *ListDatabasesOutput {
	return p.Pager.CurrentPage().(*ListDatabasesOutput)
}

// ListDatabasesResponse is the response type for the
// ListDatabases API operation.
type ListDatabasesResponse struct {
	*ListDatabasesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDatabases request.
func (r *ListDatabasesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
