// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package athena

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListTableMetadataInput struct {
	_ struct{} `type:"structure"`

	// The name of the data catalog for which table metadata should be returned.
	//
	// CatalogName is a required field
	CatalogName *string `min:"1" type:"string" required:"true"`

	// The name of the database for which table metadata should be returned.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A regex filter that pattern-matches table names. If no expression is supplied,
	// metadata for all tables are listed.
	Expression *string `type:"string"`

	// Specifies the maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListTableMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTableMetadataInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTableMetadataInput"}

	if s.CatalogName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CatalogName"))
	}
	if s.CatalogName != nil && len(*s.CatalogName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogName", 1))
	}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTableMetadataOutput struct {
	_ struct{} `type:"structure"`

	// A token generated by the Athena service that specifies where to continue
	// pagination if a previous request was truncated. To obtain the next set of
	// pages, pass in the NextToken from the response object of the previous page
	// call.
	NextToken *string `min:"1" type:"string"`

	// A list of table metadata.
	TableMetadataList []TableMetadata `type:"list"`
}

// String returns the string representation
func (s ListTableMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTableMetadata = "ListTableMetadata"

// ListTableMetadataRequest returns a request value for making API operation for
// Amazon Athena.
//
// Lists the metadata for the tables in the specified data catalog database.
//
//    // Example sending a request using ListTableMetadataRequest.
//    req := client.ListTableMetadataRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListTableMetadata
func (c *Client) ListTableMetadataRequest(input *ListTableMetadataInput) ListTableMetadataRequest {
	op := &aws.Operation{
		Name:       opListTableMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTableMetadataInput{}
	}

	req := c.newRequest(op, input, &ListTableMetadataOutput{})

	return ListTableMetadataRequest{Request: req, Input: input, Copy: c.ListTableMetadataRequest}
}

// ListTableMetadataRequest is the request type for the
// ListTableMetadata API operation.
type ListTableMetadataRequest struct {
	*aws.Request
	Input *ListTableMetadataInput
	Copy  func(*ListTableMetadataInput) ListTableMetadataRequest
}

// Send marshals and sends the ListTableMetadata API request.
func (r ListTableMetadataRequest) Send(ctx context.Context) (*ListTableMetadataResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTableMetadataResponse{
		ListTableMetadataOutput: r.Request.Data.(*ListTableMetadataOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTableMetadataRequestPaginator returns a paginator for ListTableMetadata.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTableMetadataRequest(input)
//   p := athena.NewListTableMetadataRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTableMetadataPaginator(req ListTableMetadataRequest) ListTableMetadataPaginator {
	return ListTableMetadataPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTableMetadataInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTableMetadataPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTableMetadataPaginator struct {
	aws.Pager
}

func (p *ListTableMetadataPaginator) CurrentPage() *ListTableMetadataOutput {
	return p.Pager.CurrentPage().(*ListTableMetadataOutput)
}

// ListTableMetadataResponse is the response type for the
// ListTableMetadata API operation.
type ListTableMetadataResponse struct {
	*ListTableMetadataOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTableMetadata request.
func (r *ListTableMetadataResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
