// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type DeleteLaunchConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the launch configuration.
	//
	// LaunchConfigurationName is a required field
	LaunchConfigurationName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLaunchConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLaunchConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteLaunchConfigurationInput"}

	if s.LaunchConfigurationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LaunchConfigurationName"))
	}
	if s.LaunchConfigurationName != nil && len(*s.LaunchConfigurationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LaunchConfigurationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteLaunchConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLaunchConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteLaunchConfiguration = "DeleteLaunchConfiguration"

// DeleteLaunchConfigurationRequest returns a request value for making API operation for
// Auto Scaling.
//
// Deletes the specified launch configuration.
//
// The launch configuration must not be attached to an Auto Scaling group. When
// this call completes, the launch configuration is no longer available for
// use.
//
//    // Example sending a request using DeleteLaunchConfigurationRequest.
//    req := client.DeleteLaunchConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLaunchConfiguration
func (c *Client) DeleteLaunchConfigurationRequest(input *DeleteLaunchConfigurationInput) DeleteLaunchConfigurationRequest {
	op := &aws.Operation{
		Name:       opDeleteLaunchConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLaunchConfigurationInput{}
	}

	req := c.newRequest(op, input, &DeleteLaunchConfigurationOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteLaunchConfigurationRequest{Request: req, Input: input, Copy: c.DeleteLaunchConfigurationRequest}
}

// DeleteLaunchConfigurationRequest is the request type for the
// DeleteLaunchConfiguration API operation.
type DeleteLaunchConfigurationRequest struct {
	*aws.Request
	Input *DeleteLaunchConfigurationInput
	Copy  func(*DeleteLaunchConfigurationInput) DeleteLaunchConfigurationRequest
}

// Send marshals and sends the DeleteLaunchConfiguration API request.
func (r DeleteLaunchConfigurationRequest) Send(ctx context.Context) (*DeleteLaunchConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteLaunchConfigurationResponse{
		DeleteLaunchConfigurationOutput: r.Request.Data.(*DeleteLaunchConfigurationOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteLaunchConfigurationResponse is the response type for the
// DeleteLaunchConfiguration API operation.
type DeleteLaunchConfigurationResponse struct {
	*DeleteLaunchConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteLaunchConfiguration request.
func (r *DeleteLaunchConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
