// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeInstanceRefreshesInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more instance refresh IDs.
	InstanceRefreshIds []string `type:"list"`

	// The maximum number of items to return with this call. The default value is
	// 50 and the maximum value is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstanceRefreshesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceRefreshesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeInstanceRefreshesInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeInstanceRefreshesOutput struct {
	_ struct{} `type:"structure"`

	// The instance refreshes for the specified group.
	InstanceRefreshes []InstanceRefresh `type:"list"`

	// A string that indicates that the response contains more items than can be
	// returned in a single response. To receive additional items, specify this
	// string for the NextToken value when requesting the next set of items. This
	// value is null when there are no more items to return.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstanceRefreshesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeInstanceRefreshes = "DescribeInstanceRefreshes"

// DescribeInstanceRefreshesRequest returns a request value for making API operation for
// Auto Scaling.
//
// Describes one or more instance refreshes.
//
// You can determine the status of a request by looking at the Status parameter.
// The following are the possible statuses:
//
//    * Pending - The request was created, but the operation has not started.
//
//    * InProgress - The operation is in progress.
//
//    * Successful - The operation completed successfully.
//
//    * Failed - The operation failed to complete. You can troubleshoot using
//    the status reason and the scaling activities.
//
//    * Cancelling - An ongoing operation is being cancelled. Cancellation does
//    not roll back any replacements that have already been completed, but it
//    prevents new replacements from being started.
//
//    * Cancelled - The operation is cancelled.
//
// For more information, see Replacing Auto Scaling Instances Based on an Instance
// Refresh (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html).
//
//    // Example sending a request using DescribeInstanceRefreshesRequest.
//    req := client.DescribeInstanceRefreshesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeInstanceRefreshes
func (c *Client) DescribeInstanceRefreshesRequest(input *DescribeInstanceRefreshesInput) DescribeInstanceRefreshesRequest {
	op := &aws.Operation{
		Name:       opDescribeInstanceRefreshes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceRefreshesInput{}
	}

	req := c.newRequest(op, input, &DescribeInstanceRefreshesOutput{})

	return DescribeInstanceRefreshesRequest{Request: req, Input: input, Copy: c.DescribeInstanceRefreshesRequest}
}

// DescribeInstanceRefreshesRequest is the request type for the
// DescribeInstanceRefreshes API operation.
type DescribeInstanceRefreshesRequest struct {
	*aws.Request
	Input *DescribeInstanceRefreshesInput
	Copy  func(*DescribeInstanceRefreshesInput) DescribeInstanceRefreshesRequest
}

// Send marshals and sends the DescribeInstanceRefreshes API request.
func (r DescribeInstanceRefreshesRequest) Send(ctx context.Context) (*DescribeInstanceRefreshesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeInstanceRefreshesResponse{
		DescribeInstanceRefreshesOutput: r.Request.Data.(*DescribeInstanceRefreshesOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeInstanceRefreshesResponse is the response type for the
// DescribeInstanceRefreshes API operation.
type DescribeInstanceRefreshesResponse struct {
	*DescribeInstanceRefreshesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeInstanceRefreshes request.
func (r *DescribeInstanceRefreshesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
