// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeScalingActivitiesInput struct {
	_ struct{} `type:"structure"`

	// The activity IDs of the desired scaling activities. You can specify up to
	// 50 IDs. If you omit this parameter, all activities for the past six weeks
	// are described. If unknown activities are requested, they are ignored with
	// no error. If you specify an Auto Scaling group, the results are limited to
	// that group.
	ActivityIds []string `type:"list"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The maximum number of items to return with this call. The default value is
	// 100 and the maximum value is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeScalingActivitiesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingActivitiesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeScalingActivitiesInput"}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeScalingActivitiesOutput struct {
	_ struct{} `type:"structure"`

	// The scaling activities. Activities are sorted by start time. Activities still
	// in progress are described first.
	//
	// Activities is a required field
	Activities []Activity `type:"list" required:"true"`

	// A string that indicates that the response contains more items than can be
	// returned in a single response. To receive additional items, specify this
	// string for the NextToken value when requesting the next set of items. This
	// value is null when there are no more items to return.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeScalingActivitiesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeScalingActivities = "DescribeScalingActivities"

// DescribeScalingActivitiesRequest returns a request value for making API operation for
// Auto Scaling.
//
// Describes one or more scaling activities for the specified Auto Scaling group.
//
//    // Example sending a request using DescribeScalingActivitiesRequest.
//    req := client.DescribeScalingActivitiesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities
func (c *Client) DescribeScalingActivitiesRequest(input *DescribeScalingActivitiesInput) DescribeScalingActivitiesRequest {
	op := &aws.Operation{
		Name:       opDescribeScalingActivities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScalingActivitiesInput{}
	}

	req := c.newRequest(op, input, &DescribeScalingActivitiesOutput{})

	return DescribeScalingActivitiesRequest{Request: req, Input: input, Copy: c.DescribeScalingActivitiesRequest}
}

// DescribeScalingActivitiesRequest is the request type for the
// DescribeScalingActivities API operation.
type DescribeScalingActivitiesRequest struct {
	*aws.Request
	Input *DescribeScalingActivitiesInput
	Copy  func(*DescribeScalingActivitiesInput) DescribeScalingActivitiesRequest
}

// Send marshals and sends the DescribeScalingActivities API request.
func (r DescribeScalingActivitiesRequest) Send(ctx context.Context) (*DescribeScalingActivitiesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeScalingActivitiesResponse{
		DescribeScalingActivitiesOutput: r.Request.Data.(*DescribeScalingActivitiesOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeScalingActivitiesRequestPaginator returns a paginator for DescribeScalingActivities.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeScalingActivitiesRequest(input)
//   p := autoscaling.NewDescribeScalingActivitiesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeScalingActivitiesPaginator(req DescribeScalingActivitiesRequest) DescribeScalingActivitiesPaginator {
	return DescribeScalingActivitiesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeScalingActivitiesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeScalingActivitiesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeScalingActivitiesPaginator struct {
	aws.Pager
}

func (p *DescribeScalingActivitiesPaginator) CurrentPage() *DescribeScalingActivitiesOutput {
	return p.Pager.CurrentPage().(*DescribeScalingActivitiesOutput)
}

// DescribeScalingActivitiesResponse is the response type for the
// DescribeScalingActivities API operation.
type DescribeScalingActivitiesResponse struct {
	*DescribeScalingActivitiesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeScalingActivities request.
func (r *DescribeScalingActivitiesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
