// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// Specifies how the scaling adjustment is interpreted (either an absolute number
	// or a percentage). The valid values are ChangeInCapacity, ExactCapacity, and
	// PercentChangeInCapacity.
	//
	// Required if the policy type is StepScaling or SimpleScaling. For more information,
	// see Scaling Adjustment Types (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment)
	// in the Amazon EC2 Auto Scaling User Guide.
	AdjustmentType *string `min:"1" type:"string"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The duration of the policy's cooldown period, in seconds. When a cooldown
	// period is specified here, it overrides the default cooldown period defined
	// for the Auto Scaling group.
	//
	// Valid only if the policy type is SimpleScaling. For more information, see
	// Scaling Cooldowns for Amazon EC2 Auto Scaling (https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	Cooldown *int64 `type:"integer"`

	// Indicates whether the scaling policy is enabled or disabled. The default
	// is enabled. For more information, see Disabling a Scaling Policy for an Auto
	// Scaling Group (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enable-disable-scaling-policy.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	Enabled *bool `type:"boolean"`

	// The estimated time, in seconds, until a newly launched instance can contribute
	// to the CloudWatch metrics. If not provided, the default is to use the value
	// from the default cooldown period for the Auto Scaling group.
	//
	// Valid only if the policy type is TargetTrackingScaling or StepScaling.
	EstimatedInstanceWarmup *int64 `type:"integer"`

	// The aggregation type for the CloudWatch metrics. The valid values are Minimum,
	// Maximum, and Average. If the aggregation type is null, the value is treated
	// as Average.
	//
	// Valid only if the policy type is StepScaling.
	MetricAggregationType *string `min:"1" type:"string"`

	// The minimum value to scale by when the adjustment type is PercentChangeInCapacity.
	// For example, suppose that you create a step scaling policy to scale out an
	// Auto Scaling group by 25 percent and you specify a MinAdjustmentMagnitude
	// of 2. If the group has 4 instances and the scaling policy is performed, 25
	// percent of 4 is 1. However, because you specified a MinAdjustmentMagnitude
	// of 2, Amazon EC2 Auto Scaling scales out the group by 2 instances.
	//
	// Valid only if the policy type is StepScaling or SimpleScaling. For more information,
	// see Scaling Adjustment Types (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// Some Auto Scaling groups use instance weights. In this case, set the MinAdjustmentMagnitude
	// to a value that is at least as large as your largest instance weight.
	MinAdjustmentMagnitude *int64 `type:"integer"`

	// Available for backward compatibility. Use MinAdjustmentMagnitude instead.
	MinAdjustmentStep *int64 `deprecated:"true" type:"integer"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// One of the following policy types:
	//
	//    * TargetTrackingScaling
	//
	//    * StepScaling
	//
	//    * SimpleScaling (default)
	PolicyType *string `min:"1" type:"string"`

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current capacity while a negative number removes from the
	// current capacity. For exact capacity, you must specify a positive value.
	//
	// Required if the policy type is SimpleScaling. (Not used with any other policy
	// type.)
	ScalingAdjustment *int64 `type:"integer"`

	// A set of adjustments that enable you to scale based on the size of the alarm
	// breach.
	//
	// Required if the policy type is StepScaling. (Not used with any other policy
	// type.)
	StepAdjustments []StepAdjustment `type:"list"`

	// A target tracking scaling policy. Includes support for predefined or customized
	// metrics.
	//
	// The following predefined metrics are available:
	//
	//    * ASGAverageCPUUtilization
	//
	//    * ASGAverageNetworkIn
	//
	//    * ASGAverageNetworkOut
	//
	//    * ALBRequestCountPerTarget
	//
	// If you specify ALBRequestCountPerTarget for the metric, you must specify
	// the ResourceLabel parameter with the PredefinedMetricSpecification.
	//
	// For more information, see TargetTrackingConfiguration (https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html)
	// in the Amazon EC2 Auto Scaling API Reference.
	//
	// Required if the policy type is TargetTrackingScaling.
	TargetTrackingConfiguration *TargetTrackingConfiguration `type:"structure"`
}

// String returns the string representation
func (s PutScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutScalingPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutScalingPolicyInput"}
	if s.AdjustmentType != nil && len(*s.AdjustmentType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AdjustmentType", 1))
	}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.MetricAggregationType != nil && len(*s.MetricAggregationType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MetricAggregationType", 1))
	}

	if s.PolicyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyName", 1))
	}
	if s.PolicyType != nil && len(*s.PolicyType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyType", 1))
	}
	if s.StepAdjustments != nil {
		for i, v := range s.StepAdjustments {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StepAdjustments", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.TargetTrackingConfiguration != nil {
		if err := s.TargetTrackingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TargetTrackingConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of PutScalingPolicy.
type PutScalingPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The CloudWatch alarms created for the target tracking scaling policy.
	Alarms []Alarm `type:"list"`

	// The Amazon Resource Name (ARN) of the policy.
	PolicyARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutScalingPolicy = "PutScalingPolicy"

// PutScalingPolicyRequest returns a request value for making API operation for
// Auto Scaling.
//
// Creates or updates a scaling policy for an Auto Scaling group.
//
// For more information about using scaling policies to scale your Auto Scaling
// group, see Target Tracking Scaling Policies (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html)
// and Step and Simple Scaling Policies (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
//    // Example sending a request using PutScalingPolicyRequest.
//    req := client.PutScalingPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutScalingPolicy
func (c *Client) PutScalingPolicyRequest(input *PutScalingPolicyInput) PutScalingPolicyRequest {
	op := &aws.Operation{
		Name:       opPutScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScalingPolicyInput{}
	}

	req := c.newRequest(op, input, &PutScalingPolicyOutput{})

	return PutScalingPolicyRequest{Request: req, Input: input, Copy: c.PutScalingPolicyRequest}
}

// PutScalingPolicyRequest is the request type for the
// PutScalingPolicy API operation.
type PutScalingPolicyRequest struct {
	*aws.Request
	Input *PutScalingPolicyInput
	Copy  func(*PutScalingPolicyInput) PutScalingPolicyRequest
}

// Send marshals and sends the PutScalingPolicy API request.
func (r PutScalingPolicyRequest) Send(ctx context.Context) (*PutScalingPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutScalingPolicyResponse{
		PutScalingPolicyOutput: r.Request.Data.(*PutScalingPolicyOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutScalingPolicyResponse is the response type for the
// PutScalingPolicy API operation.
type PutScalingPolicyResponse struct {
	*PutScalingPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutScalingPolicy request.
func (r *PutScalingPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
