// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RecordLifecycleActionHeartbeatInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	InstanceId *string `min:"1" type:"string"`

	// A token that uniquely identifies a specific lifecycle action associated with
	// an instance. Amazon EC2 Auto Scaling sends this token to the notification
	// target that you specified when you created the lifecycle hook.
	LifecycleActionToken *string `min:"36" type:"string"`

	// The name of the lifecycle hook.
	//
	// LifecycleHookName is a required field
	LifecycleHookName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RecordLifecycleActionHeartbeatInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordLifecycleActionHeartbeatInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RecordLifecycleActionHeartbeatInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceId", 1))
	}
	if s.LifecycleActionToken != nil && len(*s.LifecycleActionToken) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("LifecycleActionToken", 36))
	}

	if s.LifecycleHookName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LifecycleHookName"))
	}
	if s.LifecycleHookName != nil && len(*s.LifecycleHookName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LifecycleHookName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RecordLifecycleActionHeartbeatOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RecordLifecycleActionHeartbeatOutput) String() string {
	return awsutil.Prettify(s)
}

const opRecordLifecycleActionHeartbeat = "RecordLifecycleActionHeartbeat"

// RecordLifecycleActionHeartbeatRequest returns a request value for making API operation for
// Auto Scaling.
//
// Records a heartbeat for the lifecycle action associated with the specified
// token or instance. This extends the timeout by the length of time defined
// using the PutLifecycleHook API call.
//
// This step is a part of the procedure for adding a lifecycle hook to an Auto
// Scaling group:
//
// (Optional) Create a Lambda function and a rule that allows CloudWatch Events
// to invoke your Lambda function when Amazon EC2 Auto Scaling launches or terminates
// instances.
//
// (Optional) Create a notification target and an IAM role. The target can be
// either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon
// EC2 Auto Scaling to publish lifecycle notifications to the target.
//
// Create the lifecycle hook. Specify whether the hook is used when the instances
// launch or terminate.
//
// If you need more time, record the lifecycle action heartbeat to keep the
// instance in a pending state.
//
// If you finish before the timeout period ends, complete the lifecycle action.
//
// For more information, see Auto Scaling Lifecycle (https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
//    // Example sending a request using RecordLifecycleActionHeartbeatRequest.
//    req := client.RecordLifecycleActionHeartbeatRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/RecordLifecycleActionHeartbeat
func (c *Client) RecordLifecycleActionHeartbeatRequest(input *RecordLifecycleActionHeartbeatInput) RecordLifecycleActionHeartbeatRequest {
	op := &aws.Operation{
		Name:       opRecordLifecycleActionHeartbeat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RecordLifecycleActionHeartbeatInput{}
	}

	req := c.newRequest(op, input, &RecordLifecycleActionHeartbeatOutput{})

	return RecordLifecycleActionHeartbeatRequest{Request: req, Input: input, Copy: c.RecordLifecycleActionHeartbeatRequest}
}

// RecordLifecycleActionHeartbeatRequest is the request type for the
// RecordLifecycleActionHeartbeat API operation.
type RecordLifecycleActionHeartbeatRequest struct {
	*aws.Request
	Input *RecordLifecycleActionHeartbeatInput
	Copy  func(*RecordLifecycleActionHeartbeatInput) RecordLifecycleActionHeartbeatRequest
}

// Send marshals and sends the RecordLifecycleActionHeartbeat API request.
func (r RecordLifecycleActionHeartbeatRequest) Send(ctx context.Context) (*RecordLifecycleActionHeartbeatResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RecordLifecycleActionHeartbeatResponse{
		RecordLifecycleActionHeartbeatOutput: r.Request.Data.(*RecordLifecycleActionHeartbeatOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RecordLifecycleActionHeartbeatResponse is the response type for the
// RecordLifecycleActionHeartbeat API operation.
type RecordLifecycleActionHeartbeatResponse struct {
	*RecordLifecycleActionHeartbeatOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RecordLifecycleActionHeartbeat request.
func (r *RecordLifecycleActionHeartbeatResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
