// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Describes scaling activity, which is a long-running process that represents
// a change to your Auto Scaling group, such as changing its size or replacing
// an instance.
type Activity struct {
	_ struct{} `type:"structure"`

	// The ID of the activity.
	//
	// ActivityId is a required field
	ActivityId *string `type:"string" required:"true"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The reason the activity began.
	//
	// Cause is a required field
	Cause *string `min:"1" type:"string" required:"true"`

	// A friendly, more verbose description of the activity.
	Description *string `type:"string"`

	// The details about the activity.
	Details *string `type:"string"`

	// The end time of the activity.
	EndTime *time.Time `type:"timestamp"`

	// A value between 0 and 100 that indicates the progress of the activity.
	Progress *int64 `type:"integer"`

	// The start time of the activity.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`

	// The current status of the activity.
	//
	// StatusCode is a required field
	StatusCode ScalingActivityStatusCode `type:"string" required:"true" enum:"true"`

	// A friendly, more verbose description of the activity status.
	StatusMessage *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Activity) String() string {
	return awsutil.Prettify(s)
}

// Describes a policy adjustment type.
type AdjustmentType struct {
	_ struct{} `type:"structure"`

	// The policy adjustment type. The valid values are ChangeInCapacity, ExactCapacity,
	// and PercentChangeInCapacity.
	AdjustmentType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AdjustmentType) String() string {
	return awsutil.Prettify(s)
}

// Describes an alarm.
type Alarm struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the alarm.
	AlarmARN *string `min:"1" type:"string"`

	// The name of the alarm.
	AlarmName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Alarm) String() string {
	return awsutil.Prettify(s)
}

// Describes an Auto Scaling group.
type AutoScalingGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Auto Scaling group.
	AutoScalingGroupARN *string `min:"1" type:"string"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more Availability Zones for the group.
	//
	// AvailabilityZones is a required field
	AvailabilityZones []string `min:"1" type:"list" required:"true"`

	// The date and time the group was created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" required:"true"`

	// The duration of the default cooldown period, in seconds.
	//
	// DefaultCooldown is a required field
	DefaultCooldown *int64 `type:"integer" required:"true"`

	// The desired size of the group.
	//
	// DesiredCapacity is a required field
	DesiredCapacity *int64 `type:"integer" required:"true"`

	// The metrics enabled for the group.
	EnabledMetrics []EnabledMetric `type:"list"`

	// The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before
	// checking the health status of an EC2 instance that has come into service.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service to use for the health checks. The valid values are EC2 and ELB.
	// If you configure an Auto Scaling group to use ELB health checks, it considers
	// the instance unhealthy if it fails either the EC2 status checks or the load
	// balancer health checks.
	//
	// HealthCheckType is a required field
	HealthCheckType *string `min:"1" type:"string" required:"true"`

	// The EC2 instances associated with the group.
	Instances []Instance `type:"list"`

	// The name of the associated launch configuration.
	LaunchConfigurationName *string `min:"1" type:"string"`

	// The launch template for the group.
	LaunchTemplate *LaunchTemplateSpecification `type:"structure"`

	// One or more load balancers associated with the group.
	LoadBalancerNames []string `type:"list"`

	// The maximum amount of time, in seconds, that an instance can be in service.
	//
	// Valid Range: Minimum value of 0.
	MaxInstanceLifetime *int64 `type:"integer"`

	// The maximum size of the group.
	//
	// MaxSize is a required field
	MaxSize *int64 `type:"integer" required:"true"`

	// The minimum size of the group.
	//
	// MinSize is a required field
	MinSize *int64 `type:"integer" required:"true"`

	// The mixed instances policy for the group.
	MixedInstancesPolicy *MixedInstancesPolicy `type:"structure"`

	// Indicates whether newly launched instances are protected from termination
	// by Amazon EC2 Auto Scaling when scaling in.
	NewInstancesProtectedFromScaleIn *bool `type:"boolean"`

	// The name of the placement group into which to launch your instances, if any.
	PlacementGroup *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling
	// group uses to call other AWS services on your behalf.
	ServiceLinkedRoleARN *string `min:"1" type:"string"`

	// The current state of the group when the DeleteAutoScalingGroup operation
	// is in progress.
	Status *string `min:"1" type:"string"`

	// The suspended processes associated with the group.
	SuspendedProcesses []SuspendedProcess `type:"list"`

	// The tags for the group.
	Tags []TagDescription `type:"list"`

	// The Amazon Resource Names (ARN) of the target groups for your load balancer.
	TargetGroupARNs []string `type:"list"`

	// The termination policies for the group.
	TerminationPolicies []string `type:"list"`

	// One or more subnet IDs, if applicable, separated by commas.
	VPCZoneIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AutoScalingGroup) String() string {
	return awsutil.Prettify(s)
}

// Describes an EC2 instance associated with an Auto Scaling group.
type AutoScalingInstanceDetails struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group for the instance.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The Availability Zone for the instance.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `min:"1" type:"string" required:"true"`

	// The last reported health status of this instance. "Healthy" means that the
	// instance is healthy and should remain in service. "Unhealthy" means that
	// the instance is unhealthy and Amazon EC2 Auto Scaling should terminate and
	// replace it.
	//
	// HealthStatus is a required field
	HealthStatus *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// The instance type of the EC2 instance.
	InstanceType *string `min:"1" type:"string"`

	// The launch configuration used to launch the instance. This value is not available
	// if you attached the instance to the Auto Scaling group.
	LaunchConfigurationName *string `min:"1" type:"string"`

	// The launch template for the instance.
	LaunchTemplate *LaunchTemplateSpecification `type:"structure"`

	// The lifecycle state for the instance.
	//
	// LifecycleState is a required field
	LifecycleState *string `min:"1" type:"string" required:"true"`

	// Indicates whether the instance is protected from termination by Amazon EC2
	// Auto Scaling when scaling in.
	//
	// ProtectedFromScaleIn is a required field
	ProtectedFromScaleIn *bool `type:"boolean" required:"true"`

	// The number of capacity units contributed by the instance based on its instance
	// type.
	//
	// Valid Range: Minimum value of 1. Maximum value of 999.
	WeightedCapacity *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AutoScalingInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// Describes a block device mapping.
type BlockDeviceMapping struct {
	_ struct{} `type:"structure"`

	// The device name exposed to the EC2 instance (for example, /dev/sdh or xvdh).
	// For more information, see Device Naming on Linux Instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// DeviceName is a required field
	DeviceName *string `min:"1" type:"string" required:"true"`

	// Parameters used to automatically set up EBS volumes when an instance is launched.
	//
	// You can specify either VirtualName or Ebs, but not both.
	Ebs *Ebs `type:"structure"`

	// Setting this value to true suppresses the specified device included in the
	// block device mapping of the AMI.
	//
	// If NoDevice is true for the root device, instances might fail the EC2 health
	// check. In that case, Amazon EC2 Auto Scaling launches replacement instances.
	//
	// If you specify NoDevice, you cannot specify Ebs.
	NoDevice *bool `type:"boolean"`

	// The name of the virtual device (for example, ephemeral0).
	//
	// You can specify either VirtualName or Ebs, but not both.
	VirtualName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BlockDeviceMapping) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BlockDeviceMapping"}

	if s.DeviceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceName"))
	}
	if s.DeviceName != nil && len(*s.DeviceName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeviceName", 1))
	}
	if s.VirtualName != nil && len(*s.VirtualName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VirtualName", 1))
	}
	if s.Ebs != nil {
		if err := s.Ebs.Validate(); err != nil {
			invalidParams.AddNested("Ebs", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a CloudWatch metric of your choosing for a target tracking scaling
// policy to use with Amazon EC2 Auto Scaling.
//
// To create your customized metric specification:
//
//    * Add values for each required parameter from CloudWatch. You can use
//    an existing metric, or a new metric that you create. To use your own metric,
//    you must first publish the metric to CloudWatch. For more information,
//    see Publish Custom Metrics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html)
//    in the Amazon CloudWatch User Guide.
//
//    * Choose a metric that changes proportionally with capacity. The value
//    of the metric should increase or decrease in inverse proportion to the
//    number of capacity units. That is, the value of the metric should decrease
//    when capacity increases.
//
// For more information about CloudWatch, see Amazon CloudWatch Concepts (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html).
type CustomizedMetricSpecification struct {
	_ struct{} `type:"structure"`

	// The dimensions of the metric.
	//
	// Conditional: If you published your metric with dimensions, you must specify
	// the same dimensions in your scaling policy.
	Dimensions []MetricDimension `type:"list"`

	// The name of the metric.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// The namespace of the metric.
	//
	// Namespace is a required field
	Namespace *string `type:"string" required:"true"`

	// The statistic of the metric.
	//
	// Statistic is a required field
	Statistic MetricStatistic `type:"string" required:"true" enum:"true"`

	// The unit of the metric.
	Unit *string `type:"string"`
}

// String returns the string representation
func (s CustomizedMetricSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomizedMetricSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CustomizedMetricSpecification"}

	if s.MetricName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricName"))
	}

	if s.Namespace == nil {
		invalidParams.Add(aws.NewErrParamRequired("Namespace"))
	}
	if len(s.Statistic) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Statistic"))
	}
	if s.Dimensions != nil {
		for i, v := range s.Dimensions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Dimensions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes information used to set up an Amazon EBS volume specified in a
// block device mapping.
type Ebs struct {
	_ struct{} `type:"structure"`

	// Indicates whether the volume is deleted on instance termination. For Amazon
	// EC2 Auto Scaling, the default value is true.
	DeleteOnTermination *bool `type:"boolean"`

	// Specifies whether the volume should be encrypted. Encrypted EBS volumes can
	// only be attached to instances that support Amazon EBS encryption. For more
	// information, see Supported Instance Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances).
	// If your AMI uses encrypted volumes, you can also only launch it on supported
	// instance types.
	//
	// If you are creating a volume from a snapshot, you cannot specify an encryption
	// value. Volumes that are created from encrypted snapshots are automatically
	// encrypted, and volumes that are created from unencrypted snapshots are automatically
	// unencrypted. By default, encrypted snapshots use the AWS managed CMK that
	// is used for EBS encryption, but you can specify a custom CMK when you create
	// the snapshot. The ability to encrypt a snapshot during copying also allows
	// you to apply a new CMK to an already-encrypted snapshot. Volumes restored
	// from the resulting copy are only accessible using the new CMK.
	//
	// Enabling encryption by default (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default)
	// results in all EBS volumes being encrypted with the AWS managed CMK or a
	// customer managed CMK, whether or not the snapshot was encrypted.
	//
	// For more information, see Using Encryption with EBS-Backed AMIs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIEncryption.html)
	// in the Amazon EC2 User Guide for Linux Instances and Required CMK Key Policy
	// for Use with Encrypted Volumes (https://docs.aws.amazon.com/autoscaling/ec2/userguide/key-policy-requirements-EBS-encryption.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	Encrypted *bool `type:"boolean"`

	// The number of I/O operations per second (IOPS) to provision for the volume.
	// The maximum ratio of IOPS to volume size (in GiB) is 50:1. For more information,
	// see Amazon EBS Volume Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// Required when the volume type is io1. (Not used with standard, gp2, st1,
	// or sc1 volumes.)
	Iops *int64 `min:"100" type:"integer"`

	// The snapshot ID of the volume to use.
	//
	// You must specify either a VolumeSize or a SnapshotId.
	SnapshotId *string `min:"1" type:"string"`

	// The volume size, in Gibibytes (GiB).
	//
	// This can be a number from 1-1,024 for standard, 4-16,384 for io1, 1-16,384
	// for gp2, and 500-16,384 for st1 and sc1. If you specify a snapshot, the volume
	// size must be equal to or larger than the snapshot size.
	//
	// Default: If you create a volume from a snapshot and you don't specify a volume
	// size, the default is the snapshot size.
	//
	// You must specify either a VolumeSize or a SnapshotId. If you specify both
	// SnapshotId and VolumeSize, the volume size must be equal or greater than
	// the size of the snapshot.
	VolumeSize *int64 `min:"1" type:"integer"`

	// The volume type, which can be standard for Magnetic, io1 for Provisioned
	// IOPS SSD, gp2 for General Purpose SSD, st1 for Throughput Optimized HDD,
	// or sc1 for Cold HDD. For more information, see Amazon EBS Volume Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// Valid Values: standard | io1 | gp2 | st1 | sc1
	VolumeType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Ebs) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ebs) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Ebs"}
	if s.Iops != nil && *s.Iops < 100 {
		invalidParams.Add(aws.NewErrParamMinValue("Iops", 100))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SnapshotId", 1))
	}
	if s.VolumeSize != nil && *s.VolumeSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("VolumeSize", 1))
	}
	if s.VolumeType != nil && len(*s.VolumeType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VolumeType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an enabled metric.
type EnabledMetric struct {
	_ struct{} `type:"structure"`

	// The granularity of the metric. The only valid value is 1Minute.
	Granularity *string `min:"1" type:"string"`

	// One of the following metrics:
	//
	//    * GroupMinSize
	//
	//    * GroupMaxSize
	//
	//    * GroupDesiredCapacity
	//
	//    * GroupInServiceInstances
	//
	//    * GroupPendingInstances
	//
	//    * GroupStandbyInstances
	//
	//    * GroupTerminatingInstances
	//
	//    * GroupTotalInstances
	//
	//    * GroupInServiceCapacity
	//
	//    * GroupPendingCapacity
	//
	//    * GroupStandbyCapacity
	//
	//    * GroupTerminatingCapacity
	//
	//    * GroupTotalCapacity
	Metric *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EnabledMetric) String() string {
	return awsutil.Prettify(s)
}

// Describes a scheduled action that could not be created, updated, or deleted.
type FailedScheduledUpdateGroupActionRequest struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `min:"1" type:"string"`

	// The error message accompanying the error code.
	ErrorMessage *string `type:"string"`

	// The name of the scheduled action.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s FailedScheduledUpdateGroupActionRequest) String() string {
	return awsutil.Prettify(s)
}

// Describes a filter that is used to return a more specific list of results
// when describing tags.
//
// For more information, see Tagging Auto Scaling Groups and Instances (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html)
// in the Amazon EC2 Auto Scaling User Guide.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. The valid values are: auto-scaling-group, key, value,
	// and propagate-at-launch.
	Name *string `type:"string"`

	// One or more filter values. Filter values are case-sensitive.
	Values []string `type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// Describes an EC2 instance.
type Instance struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which the instance is running.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `min:"1" type:"string" required:"true"`

	// The last reported health status of the instance. "Healthy" means that the
	// instance is healthy and should remain in service. "Unhealthy" means that
	// the instance is unhealthy and that Amazon EC2 Auto Scaling should terminate
	// and replace it.
	//
	// HealthStatus is a required field
	HealthStatus *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// The instance type of the EC2 instance.
	InstanceType *string `min:"1" type:"string"`

	// The launch configuration associated with the instance.
	LaunchConfigurationName *string `min:"1" type:"string"`

	// The launch template for the instance.
	LaunchTemplate *LaunchTemplateSpecification `type:"structure"`

	// A description of the current lifecycle state. The Quarantined state is not
	// used.
	//
	// LifecycleState is a required field
	LifecycleState LifecycleState `type:"string" required:"true" enum:"true"`

	// Indicates whether the instance is protected from termination by Amazon EC2
	// Auto Scaling when scaling in.
	//
	// ProtectedFromScaleIn is a required field
	ProtectedFromScaleIn *bool `type:"boolean" required:"true"`

	// The number of capacity units contributed by the instance based on its instance
	// type.
	//
	// Valid Range: Minimum value of 1. Maximum value of 999.
	WeightedCapacity *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// Describes whether detailed monitoring is enabled for the Auto Scaling instances.
type InstanceMonitoring struct {
	_ struct{} `type:"structure"`

	// If true, detailed monitoring is enabled. Otherwise, basic monitoring is enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s InstanceMonitoring) String() string {
	return awsutil.Prettify(s)
}

// Describes an instance refresh for an Auto Scaling group.
type InstanceRefresh struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The date and time at which the instance refresh ended.
	EndTime *time.Time `type:"timestamp"`

	// The instance refresh ID.
	InstanceRefreshId *string `min:"1" type:"string"`

	// The number of instances remaining to update before the instance refresh is
	// complete.
	InstancesToUpdate *int64 `type:"integer"`

	// The percentage of the instance refresh that is complete. For each instance
	// replacement, Amazon EC2 Auto Scaling tracks the instance's health status
	// and warm-up time. When the instance's health status changes to healthy and
	// the specified warm-up time passes, the instance is considered updated and
	// added to the percentage complete.
	PercentageComplete *int64 `type:"integer"`

	// The date and time at which the instance refresh began.
	StartTime *time.Time `type:"timestamp"`

	// The current status for the instance refresh operation:
	//
	//    * Pending - The request was created, but the operation has not started.
	//
	//    * InProgress - The operation is in progress.
	//
	//    * Successful - The operation completed successfully.
	//
	//    * Failed - The operation failed to complete. You can troubleshoot using
	//    the status reason and the scaling activities.
	//
	//    * Cancelling - An ongoing operation is being cancelled. Cancellation does
	//    not roll back any replacements that have already been completed, but it
	//    prevents new replacements from being started.
	//
	//    * Cancelled - The operation is cancelled.
	Status InstanceRefreshStatus `type:"string" enum:"true"`

	// Provides more details about the current status of the instance refresh.
	StatusReason *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InstanceRefresh) String() string {
	return awsutil.Prettify(s)
}

// Describes an instances distribution for an Auto Scaling group with a MixedInstancesPolicy.
//
// The instances distribution specifies the distribution of On-Demand Instances
// and Spot Instances, the maximum price to pay for Spot Instances, and how
// the Auto Scaling group allocates instance types to fulfill On-Demand and
// Spot capacity.
//
// When you update SpotAllocationStrategy, SpotInstancePools, or SpotMaxPrice,
// this update action does not deploy any changes across the running Amazon
// EC2 instances in the group. Your existing Spot Instances continue to run
// as long as the maximum price for those instances is higher than the current
// Spot price. When scale out occurs, Amazon EC2 Auto Scaling launches instances
// based on the new settings. When scale in occurs, Amazon EC2 Auto Scaling
// terminates instances according to the group's termination policies.
type InstancesDistribution struct {
	_ struct{} `type:"structure"`

	// Indicates how to allocate instance types to fulfill On-Demand capacity.
	//
	// The only valid value is prioritized, which is also the default value. This
	// strategy uses the order of instance type overrides for the LaunchTemplate
	// to define the launch priority of each instance type. The first instance type
	// in the array is prioritized higher than the last. If all your On-Demand capacity
	// cannot be fulfilled using your highest priority instance, then the Auto Scaling
	// groups launches the remaining capacity using the second priority instance
	// type, and so on.
	OnDemandAllocationStrategy *string `type:"string"`

	// The minimum amount of the Auto Scaling group's capacity that must be fulfilled
	// by On-Demand Instances. This base portion is provisioned first as your group
	// scales.
	//
	// Default if not set is 0. If you leave it set to 0, On-Demand Instances are
	// launched as a percentage of the Auto Scaling group's desired capacity, per
	// the OnDemandPercentageAboveBaseCapacity setting.
	//
	// An update to this setting means a gradual replacement of instances to maintain
	// the specified number of On-Demand Instances for your base capacity. When
	// replacing instances, Amazon EC2 Auto Scaling launches new instances before
	// terminating the old ones.
	OnDemandBaseCapacity *int64 `type:"integer"`

	// Controls the percentages of On-Demand Instances and Spot Instances for your
	// additional capacity beyond OnDemandBaseCapacity.
	//
	// Default if not set is 100. If you leave it set to 100, the percentages are
	// 100% for On-Demand Instances and 0% for Spot Instances.
	//
	// An update to this setting means a gradual replacement of instances to maintain
	// the percentage of On-Demand Instances for your additional capacity above
	// the base capacity. When replacing instances, Amazon EC2 Auto Scaling launches
	// new instances before terminating the old ones.
	//
	// Valid Range: Minimum value of 0. Maximum value of 100.
	OnDemandPercentageAboveBaseCapacity *int64 `type:"integer"`

	// Indicates how to allocate instances across Spot Instance pools.
	//
	// If the allocation strategy is lowest-price, the Auto Scaling group launches
	// instances using the Spot pools with the lowest price, and evenly allocates
	// your instances across the number of Spot pools that you specify. If the allocation
	// strategy is capacity-optimized, the Auto Scaling group launches instances
	// using Spot pools that are optimally chosen based on the available Spot capacity.
	//
	// The default Spot allocation strategy for calls that you make through the
	// API, the AWS CLI, or the AWS SDKs is lowest-price. The default Spot allocation
	// strategy for the AWS Management Console is capacity-optimized.
	//
	// Valid values: lowest-price | capacity-optimized
	SpotAllocationStrategy *string `type:"string"`

	// The number of Spot Instance pools across which to allocate your Spot Instances.
	// The Spot pools are determined from the different instance types in the Overrides
	// array of LaunchTemplate. Default if not set is 2.
	//
	// Used only when the Spot allocation strategy is lowest-price.
	//
	// Valid Range: Minimum value of 1. Maximum value of 20.
	SpotInstancePools *int64 `type:"integer"`

	// The maximum price per unit hour that you are willing to pay for a Spot Instance.
	// If you leave the value of this parameter blank (which is the default), the
	// maximum Spot price is set at the On-Demand price.
	//
	// To remove a value that you previously set, include the parameter but leave
	// the value blank.
	SpotMaxPrice *string `type:"string"`
}

// String returns the string representation
func (s InstancesDistribution) String() string {
	return awsutil.Prettify(s)
}

// Describes a launch configuration.
type LaunchConfiguration struct {
	_ struct{} `type:"structure"`

	// For Auto Scaling groups that are running in a VPC, specifies whether to assign
	// a public IP address to the group's instances.
	//
	// For more information, see Launching Auto Scaling Instances in a VPC (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	AssociatePublicIpAddress *bool `type:"boolean"`

	// A block device mapping, which specifies the block devices for the instance.
	//
	// For more information, see Block Device Mapping (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	BlockDeviceMappings []BlockDeviceMapping `type:"list"`

	// The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to.
	//
	// For more information, see ClassicLink (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon EC2 User Guide for Linux Instances and Linking EC2-Classic
	// Instances to a VPC (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink)
	// in the Amazon EC2 Auto Scaling User Guide.
	ClassicLinkVPCId *string `min:"1" type:"string"`

	// The IDs of one or more security groups for the VPC specified in ClassicLinkVPCId.
	//
	// For more information, see ClassicLink (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon EC2 User Guide for Linux Instances and Linking EC2-Classic
	// Instances to a VPC (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink)
	// in the Amazon EC2 Auto Scaling User Guide.
	ClassicLinkVPCSecurityGroups []string `type:"list"`

	// The creation date and time for the launch configuration.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" required:"true"`

	// Specifies whether the launch configuration is optimized for EBS I/O (true)
	// or not (false).
	//
	// For more information, see Amazon EBS-Optimized Instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	EbsOptimized *bool `type:"boolean"`

	// The name or the Amazon Resource Name (ARN) of the instance profile associated
	// with the IAM role for the instance. The instance profile contains the IAM
	// role.
	//
	// For more information, see IAM Role for Applications That Run on Amazon EC2
	// Instances (https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	IamInstanceProfile *string `min:"1" type:"string"`

	// The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.
	//
	// For more information, see Finding an AMI (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// ImageId is a required field
	ImageId *string `min:"1" type:"string" required:"true"`

	// Controls whether instances in this group are launched with detailed (true)
	// or basic (false) monitoring.
	//
	// For more information, see Configure Monitoring for Auto Scaling Instances
	// (https://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html#enable-as-instance-metrics)
	// in the Amazon EC2 Auto Scaling User Guide.
	InstanceMonitoring *InstanceMonitoring `type:"structure"`

	// The instance type for the instances.
	//
	// For information about available instance types, see Available Instance Types
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// The ID of the kernel associated with the AMI.
	KernelId *string `min:"1" type:"string"`

	// The name of the key pair.
	//
	// For more information, see Amazon EC2 Key Pairs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	KeyName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the launch configuration.
	LaunchConfigurationARN *string `min:"1" type:"string"`

	// The name of the launch configuration.
	//
	// LaunchConfigurationName is a required field
	LaunchConfigurationName *string `min:"1" type:"string" required:"true"`

	// The tenancy of the instance, either default or dedicated. An instance with
	// dedicated tenancy runs on isolated, single-tenant hardware and can only be
	// launched into a VPC.
	//
	// For more information, see Instance Placement Tenancy (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-vpc-tenancy)
	// in the Amazon EC2 Auto Scaling User Guide.
	PlacementTenancy *string `min:"1" type:"string"`

	// The ID of the RAM disk associated with the AMI.
	RamdiskId *string `min:"1" type:"string"`

	// A list that contains the security groups to assign to the instances in the
	// Auto Scaling group.
	//
	// For more information, see Security Groups for Your VPC (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
	// in the Amazon Virtual Private Cloud User Guide.
	SecurityGroups []string `type:"list"`

	// The maximum hourly price to be paid for any Spot Instance launched to fulfill
	// the request. Spot Instances are launched when the price you specify exceeds
	// the current Spot price.
	//
	// For more information, see Launching Spot Instances in Your Auto Scaling Group
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	SpotPrice *string `min:"1" type:"string"`

	// The Base64-encoded user data to make available to the launched EC2 instances.
	//
	// For more information, see Instance Metadata and User Data (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	UserData *string `type:"string"`
}

// String returns the string representation
func (s LaunchConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Describes a launch template and overrides.
//
// The overrides are used to override the instance type specified by the launch
// template with multiple instance types that can be used to launch On-Demand
// Instances and Spot Instances.
//
// When you update the launch template or overrides, existing Amazon EC2 instances
// continue to run. When scale out occurs, Amazon EC2 Auto Scaling launches
// instances to match the new settings. When scale in occurs, Amazon EC2 Auto
// Scaling terminates instances according to the group's termination policies.
type LaunchTemplate struct {
	_ struct{} `type:"structure"`

	// The launch template to use. You must specify either the launch template ID
	// or launch template name in the request.
	LaunchTemplateSpecification *LaunchTemplateSpecification `type:"structure"`

	// Any parameters that you specify override the same parameters in the launch
	// template. Currently, the only supported override is instance type. You can
	// specify between 1 and 20 instance types.
	//
	// If not provided, Amazon EC2 Auto Scaling will use the instance type specified
	// in the launch template to launch instances.
	Overrides []LaunchTemplateOverrides `type:"list"`
}

// String returns the string representation
func (s LaunchTemplate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchTemplate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LaunchTemplate"}
	if s.LaunchTemplateSpecification != nil {
		if err := s.LaunchTemplateSpecification.Validate(); err != nil {
			invalidParams.AddNested("LaunchTemplateSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.Overrides != nil {
		for i, v := range s.Overrides {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Overrides", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an override for a launch template. Currently, the only supported
// override is instance type.
//
// The maximum number of instance type overrides that can be associated with
// an Auto Scaling group is 20.
type LaunchTemplateOverrides struct {
	_ struct{} `type:"structure"`

	// The instance type. You must use an instance type that is supported in your
	// requested Region and Availability Zones.
	//
	// For information about available instance types, see Available Instance Types
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes)
	// in the Amazon Elastic Compute Cloud User Guide.
	InstanceType *string `min:"1" type:"string"`

	// The number of capacity units, which gives the instance type a proportional
	// weight to other instance types. For example, larger instance types are generally
	// weighted more than smaller instance types. These are the same units that
	// you chose to set the desired capacity in terms of instances, or a performance
	// attribute such as vCPUs, memory, or I/O.
	//
	// For more information, see Instance Weighting for Amazon EC2 Auto Scaling
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// Valid Range: Minimum value of 1. Maximum value of 999.
	WeightedCapacity *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LaunchTemplateOverrides) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchTemplateOverrides) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LaunchTemplateOverrides"}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceType", 1))
	}
	if s.WeightedCapacity != nil && len(*s.WeightedCapacity) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WeightedCapacity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the Amazon EC2 launch template and the launch template version
// that can be used by an Auto Scaling group to configure Amazon EC2 instances.
//
// The launch template that is specified must be configured for use with an
// Auto Scaling group. For more information, see Creating a Launch Template
// for an Auto Scaling Group (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html)
// in the Amazon EC2 Auto Scaling User Guide.
type LaunchTemplateSpecification struct {
	_ struct{} `type:"structure"`

	// The ID of the launch template. To get the template ID, use the Amazon EC2
	// DescribeLaunchTemplates (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html)
	// API operation. New launch templates can be created using the Amazon EC2 CreateLaunchTemplate
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html)
	// API.
	//
	// You must specify either a template ID or a template name.
	LaunchTemplateId *string `min:"1" type:"string"`

	// The name of the launch template. To get the template name, use the Amazon
	// EC2 DescribeLaunchTemplates (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html)
	// API operation. New launch templates can be created using the Amazon EC2 CreateLaunchTemplate
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html)
	// API.
	//
	// You must specify either a template ID or a template name.
	LaunchTemplateName *string `min:"3" type:"string"`

	// The version number, $Latest, or $Default. To get the version number, use
	// the Amazon EC2 DescribeLaunchTemplateVersions (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplateVersions.html)
	// API operation. New launch template versions can be created using the Amazon
	// EC2 CreateLaunchTemplateVersion (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplateVersion.html)
	// API.
	//
	// If the value is $Latest, Amazon EC2 Auto Scaling selects the latest version
	// of the launch template when launching instances. If the value is $Default,
	// Amazon EC2 Auto Scaling selects the default version of the launch template
	// when launching instances. The default value is $Default.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LaunchTemplateSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchTemplateSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LaunchTemplateSpecification"}
	if s.LaunchTemplateId != nil && len(*s.LaunchTemplateId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LaunchTemplateId", 1))
	}
	if s.LaunchTemplateName != nil && len(*s.LaunchTemplateName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("LaunchTemplateName", 3))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a lifecycle hook, which tells Amazon EC2 Auto Scaling that you
// want to perform an action whenever it launches instances or terminates instances.
type LifecycleHook struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group for the lifecycle hook.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// Defines the action the Auto Scaling group should take when the lifecycle
	// hook timeout elapses or if an unexpected failure occurs. The possible values
	// are CONTINUE and ABANDON.
	DefaultResult *string `type:"string"`

	// The maximum time, in seconds, that an instance can remain in a Pending:Wait
	// or Terminating:Wait state. The maximum is 172800 seconds (48 hours) or 100
	// times HeartbeatTimeout, whichever is smaller.
	GlobalTimeout *int64 `type:"integer"`

	// The maximum time, in seconds, that can elapse before the lifecycle hook times
	// out. If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the
	// action that you specified in the DefaultResult parameter.
	HeartbeatTimeout *int64 `type:"integer"`

	// The name of the lifecycle hook.
	LifecycleHookName *string `min:"1" type:"string"`

	// The state of the EC2 instance to which to attach the lifecycle hook. The
	// following are possible values:
	//
	//    * autoscaling:EC2_INSTANCE_LAUNCHING
	//
	//    * autoscaling:EC2_INSTANCE_TERMINATING
	LifecycleTransition *string `type:"string"`

	// Additional information that is included any time Amazon EC2 Auto Scaling
	// sends a message to the notification target.
	NotificationMetadata *string `min:"1" type:"string"`

	// The ARN of the target that Amazon EC2 Auto Scaling sends notifications to
	// when an instance is in the transition state for the lifecycle hook. The notification
	// target can be either an SQS queue or an SNS topic.
	NotificationTargetARN *string `min:"1" type:"string"`

	// The ARN of the IAM role that allows the Auto Scaling group to publish to
	// the specified notification target.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LifecycleHook) String() string {
	return awsutil.Prettify(s)
}

// Describes information used to specify a lifecycle hook for an Auto Scaling
// group.
//
// A lifecycle hook tells Amazon EC2 Auto Scaling to perform an action on an
// instance when the instance launches (before it is put into service) or as
// the instance terminates (before it is fully terminated).
//
// This step is a part of the procedure for creating a lifecycle hook for an
// Auto Scaling group:
//
// (Optional) Create a Lambda function and a rule that allows CloudWatch Events
// to invoke your Lambda function when Amazon EC2 Auto Scaling launches or terminates
// instances.
//
// (Optional) Create a notification target and an IAM role. The target can be
// either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon
// EC2 Auto Scaling to publish lifecycle notifications to the target.
//
// Create the lifecycle hook. Specify whether the hook is used when the instances
// launch or terminate.
//
// If you need more time, record the lifecycle action heartbeat to keep the
// instance in a pending state.
//
// If you finish before the timeout period ends, complete the lifecycle action.
//
// For more information, see Amazon EC2 Auto Scaling Lifecycle Hooks (https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html)
// in the Amazon EC2 Auto Scaling User Guide.
type LifecycleHookSpecification struct {
	_ struct{} `type:"structure"`

	// Defines the action the Auto Scaling group should take when the lifecycle
	// hook timeout elapses or if an unexpected failure occurs. The valid values
	// are CONTINUE and ABANDON. The default value is ABANDON.
	DefaultResult *string `type:"string"`

	// The maximum time, in seconds, that can elapse before the lifecycle hook times
	// out.
	//
	// If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action
	// that you specified in the DefaultResult parameter. You can prevent the lifecycle
	// hook from timing out by calling RecordLifecycleActionHeartbeat.
	HeartbeatTimeout *int64 `type:"integer"`

	// The name of the lifecycle hook.
	//
	// LifecycleHookName is a required field
	LifecycleHookName *string `min:"1" type:"string" required:"true"`

	// The state of the EC2 instance to which you want to attach the lifecycle hook.
	// The valid values are:
	//
	//    * autoscaling:EC2_INSTANCE_LAUNCHING
	//
	//    * autoscaling:EC2_INSTANCE_TERMINATING
	//
	// LifecycleTransition is a required field
	LifecycleTransition *string `type:"string" required:"true"`

	// Additional information that you want to include any time Amazon EC2 Auto
	// Scaling sends a message to the notification target.
	NotificationMetadata *string `min:"1" type:"string"`

	// The ARN of the target that Amazon EC2 Auto Scaling sends notifications to
	// when an instance is in the transition state for the lifecycle hook. The notification
	// target can be either an SQS queue or an SNS topic.
	NotificationTargetARN *string `type:"string"`

	// The ARN of the IAM role that allows the Auto Scaling group to publish to
	// the specified notification target, for example, an Amazon SNS topic or an
	// Amazon SQS queue.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LifecycleHookSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleHookSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LifecycleHookSpecification"}

	if s.LifecycleHookName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LifecycleHookName"))
	}
	if s.LifecycleHookName != nil && len(*s.LifecycleHookName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LifecycleHookName", 1))
	}

	if s.LifecycleTransition == nil {
		invalidParams.Add(aws.NewErrParamRequired("LifecycleTransition"))
	}
	if s.NotificationMetadata != nil && len(*s.NotificationMetadata) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NotificationMetadata", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the state of a Classic Load Balancer.
//
// If you specify a load balancer when creating the Auto Scaling group, the
// state of the load balancer is InService.
//
// If you attach a load balancer to an existing Auto Scaling group, the initial
// state is Adding. The state transitions to Added after all instances in the
// group are registered with the load balancer. If Elastic Load Balancing health
// checks are enabled for the load balancer, the state transitions to InService
// after at least one instance in the group passes the health check. If EC2
// health checks are enabled instead, the load balancer remains in the Added
// state.
type LoadBalancerState struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `min:"1" type:"string"`

	// One of the following load balancer states:
	//
	//    * Adding - The instances in the group are being registered with the load
	//    balancer.
	//
	//    * Added - All instances in the group are registered with the load balancer.
	//
	//    * InService - At least one instance in the group passed an ELB health
	//    check.
	//
	//    * Removing - The instances in the group are being deregistered from the
	//    load balancer. If connection draining is enabled, Elastic Load Balancing
	//    waits for in-flight requests to complete before deregistering the instances.
	//
	//    * Removed - All instances in the group are deregistered from the load
	//    balancer.
	State *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LoadBalancerState) String() string {
	return awsutil.Prettify(s)
}

// Describes the state of a target group.
//
// If you attach a target group to an existing Auto Scaling group, the initial
// state is Adding. The state transitions to Added after all Auto Scaling instances
// are registered with the target group. If Elastic Load Balancing health checks
// are enabled, the state transitions to InService after at least one Auto Scaling
// instance passes the health check. If EC2 health checks are enabled instead,
// the target group remains in the Added state.
type LoadBalancerTargetGroupState struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	LoadBalancerTargetGroupARN *string `min:"1" type:"string"`

	// The state of the target group.
	//
	//    * Adding - The Auto Scaling instances are being registered with the target
	//    group.
	//
	//    * Added - All Auto Scaling instances are registered with the target group.
	//
	//    * InService - At least one Auto Scaling instance passed an ELB health
	//    check.
	//
	//    * Removing - The Auto Scaling instances are being deregistered from the
	//    target group. If connection draining is enabled, Elastic Load Balancing
	//    waits for in-flight requests to complete before deregistering the instances.
	//
	//    * Removed - All Auto Scaling instances are deregistered from the target
	//    group.
	State *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LoadBalancerTargetGroupState) String() string {
	return awsutil.Prettify(s)
}

// Describes a metric.
type MetricCollectionType struct {
	_ struct{} `type:"structure"`

	// One of the following metrics:
	//
	//    * GroupMinSize
	//
	//    * GroupMaxSize
	//
	//    * GroupDesiredCapacity
	//
	//    * GroupInServiceInstances
	//
	//    * GroupPendingInstances
	//
	//    * GroupStandbyInstances
	//
	//    * GroupTerminatingInstances
	//
	//    * GroupTotalInstances
	Metric *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MetricCollectionType) String() string {
	return awsutil.Prettify(s)
}

// Describes the dimension of a metric.
type MetricDimension struct {
	_ struct{} `type:"structure"`

	// The name of the dimension.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the dimension.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MetricDimension) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricDimension) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MetricDimension"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a granularity of a metric.
type MetricGranularityType struct {
	_ struct{} `type:"structure"`

	// The granularity. The only valid value is 1Minute.
	Granularity *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MetricGranularityType) String() string {
	return awsutil.Prettify(s)
}

// Describes a mixed instances policy for an Auto Scaling group. With mixed
// instances, your Auto Scaling group can provision a combination of On-Demand
// Instances and Spot Instances across multiple instance types. For more information,
// see Auto Scaling Groups with Multiple Instance Types and Purchase Options
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
// You can create a mixed instances policy for a new Auto Scaling group, or
// you can create it for an existing group by updating the group to specify
// MixedInstancesPolicy as the top-level parameter instead of a launch configuration
// or launch template. For more information, see CreateAutoScalingGroup and
// UpdateAutoScalingGroup.
type MixedInstancesPolicy struct {
	_ struct{} `type:"structure"`

	// The instances distribution to use.
	//
	// If you leave this parameter unspecified, the value for each parameter in
	// InstancesDistribution uses a default value.
	InstancesDistribution *InstancesDistribution `type:"structure"`

	// The launch template and instance types (overrides).
	//
	// Required when creating a mixed instances policy.
	LaunchTemplate *LaunchTemplate `type:"structure"`
}

// String returns the string representation
func (s MixedInstancesPolicy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MixedInstancesPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MixedInstancesPolicy"}
	if s.LaunchTemplate != nil {
		if err := s.LaunchTemplate.Validate(); err != nil {
			invalidParams.AddNested("LaunchTemplate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a notification.
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// One of the following event notification types:
	//
	//    * autoscaling:EC2_INSTANCE_LAUNCH
	//
	//    * autoscaling:EC2_INSTANCE_LAUNCH_ERROR
	//
	//    * autoscaling:EC2_INSTANCE_TERMINATE
	//
	//    * autoscaling:EC2_INSTANCE_TERMINATE_ERROR
	//
	//    * autoscaling:TEST_NOTIFICATION
	NotificationType *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (Amazon SNS) topic.
	TopicARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Represents a predefined metric for a target tracking scaling policy to use
// with Amazon EC2 Auto Scaling.
type PredefinedMetricSpecification struct {
	_ struct{} `type:"structure"`

	// The metric type. The following predefined metrics are available:
	//
	//    * ASGAverageCPUUtilization - Average CPU utilization of the Auto Scaling
	//    group.
	//
	//    * ASGAverageNetworkIn - Average number of bytes received on all network
	//    interfaces by the Auto Scaling group.
	//
	//    * ASGAverageNetworkOut - Average number of bytes sent out on all network
	//    interfaces by the Auto Scaling group.
	//
	//    * ALBRequestCountPerTarget - Number of requests completed per target in
	//    an Application Load Balancer target group.
	//
	// PredefinedMetricType is a required field
	PredefinedMetricType MetricType `type:"string" required:"true" enum:"true"`

	// Identifies the resource associated with the metric type. You can't specify
	// a resource label unless the metric type is ALBRequestCountPerTarget and there
	// is a target group attached to the Auto Scaling group.
	//
	// Elastic Load Balancing sends data about your load balancers to Amazon CloudWatch.
	// CloudWatch collects the data and specifies the format to use to access the
	// data. The format is app/load-balancer-name/load-balancer-id/targetgroup/target-group-name/target-group-id
	// , where
	//
	//    * app/load-balancer-name/load-balancer-id is the final portion of the
	//    load balancer ARN, and
	//
	//    * targetgroup/target-group-name/target-group-id is the final portion of
	//    the target group ARN.
	//
	// To find the ARN for an Application Load Balancer, use the DescribeLoadBalancers
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html)
	// API operation. To find the ARN for the target group, use the DescribeTargetGroups
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html)
	// API operation.
	ResourceLabel *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PredefinedMetricSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PredefinedMetricSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PredefinedMetricSpecification"}
	if len(s.PredefinedMetricType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("PredefinedMetricType"))
	}
	if s.ResourceLabel != nil && len(*s.ResourceLabel) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceLabel", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a process type.
//
// For more information, see Scaling Processes (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html#process-types)
// in the Amazon EC2 Auto Scaling User Guide.
type ProcessType struct {
	_ struct{} `type:"structure"`

	// One of the following processes:
	//
	//    * Launch
	//
	//    * Terminate
	//
	//    * AddToLoadBalancer
	//
	//    * AlarmNotification
	//
	//    * AZRebalance
	//
	//    * HealthCheck
	//
	//    * InstanceRefresh
	//
	//    * ReplaceUnhealthy
	//
	//    * ScheduledActions
	//
	// ProcessName is a required field
	ProcessName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ProcessType) String() string {
	return awsutil.Prettify(s)
}

// Describes information used to start an instance refresh.
type RefreshPreferences struct {
	_ struct{} `type:"structure"`

	// The number of seconds until a newly launched instance is configured and ready
	// to use. During this time, Amazon EC2 Auto Scaling does not immediately move
	// on to the next replacement. The default is to use the value for the health
	// check grace period defined for the group.
	InstanceWarmup *int64 `type:"integer"`

	// The amount of capacity in the Auto Scaling group that must remain healthy
	// during an instance refresh to allow the operation to continue, as a percentage
	// of the desired capacity of the Auto Scaling group (rounded up to the nearest
	// integer). The default is 90.
	MinHealthyPercentage *int64 `type:"integer"`
}

// String returns the string representation
func (s RefreshPreferences) String() string {
	return awsutil.Prettify(s)
}

// Describes a scaling policy.
type ScalingPolicy struct {
	_ struct{} `type:"structure"`

	// Specifies how the scaling adjustment is interpreted (either an absolute number
	// or a percentage). The valid values are ChangeInCapacity, ExactCapacity, and
	// PercentChangeInCapacity.
	AdjustmentType *string `min:"1" type:"string"`

	// The CloudWatch alarms related to the policy.
	Alarms []Alarm `type:"list"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The duration of the policy's cooldown period, in seconds.
	Cooldown *int64 `type:"integer"`

	// Indicates whether the policy is enabled (true) or disabled (false).
	Enabled *bool `type:"boolean"`

	// The estimated time, in seconds, until a newly launched instance can contribute
	// to the CloudWatch metrics.
	EstimatedInstanceWarmup *int64 `type:"integer"`

	// The aggregation type for the CloudWatch metrics. The valid values are Minimum,
	// Maximum, and Average.
	MetricAggregationType *string `min:"1" type:"string"`

	// The minimum value to scale by when the adjustment type is PercentChangeInCapacity.
	MinAdjustmentMagnitude *int64 `type:"integer"`

	// Available for backward compatibility. Use MinAdjustmentMagnitude instead.
	MinAdjustmentStep *int64 `deprecated:"true" type:"integer"`

	// The Amazon Resource Name (ARN) of the policy.
	PolicyARN *string `min:"1" type:"string"`

	// The name of the scaling policy.
	PolicyName *string `min:"1" type:"string"`

	// One of the following policy types:
	//
	//    * TargetTrackingScaling
	//
	//    * StepScaling
	//
	//    * SimpleScaling (default)
	//
	// For more information, see Target Tracking Scaling Policies (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html)
	// and Step and Simple Scaling Policies (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	PolicyType *string `min:"1" type:"string"`

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current capacity while a negative number removes from the
	// current capacity.
	ScalingAdjustment *int64 `type:"integer"`

	// A set of adjustments that enable you to scale based on the size of the alarm
	// breach.
	StepAdjustments []StepAdjustment `type:"list"`

	// A target tracking scaling policy.
	TargetTrackingConfiguration *TargetTrackingConfiguration `type:"structure"`
}

// String returns the string representation
func (s ScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// Describes a scheduled scaling action.
type ScheduledUpdateGroupAction struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The desired capacity is the initial capacity of the Auto Scaling group after
	// the scheduled action runs and the capacity it attempts to maintain.
	DesiredCapacity *int64 `type:"integer"`

	// The date and time in UTC for the recurring schedule to end. For example,
	// "2019-06-01T00:00:00Z".
	EndTime *time.Time `type:"timestamp"`

	// The maximum size of the Auto Scaling group.
	MaxSize *int64 `type:"integer"`

	// The minimum size of the Auto Scaling group.
	MinSize *int64 `type:"integer"`

	// The recurring schedule for the action, in Unix cron syntax format.
	//
	// When StartTime and EndTime are specified with Recurrence, they form the boundaries
	// of when the recurring action starts and stops.
	Recurrence *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the scheduled action.
	ScheduledActionARN *string `min:"1" type:"string"`

	// The name of the scheduled action.
	ScheduledActionName *string `min:"1" type:"string"`

	// The date and time in UTC for this action to start. For example, "2019-06-01T00:00:00Z".
	StartTime *time.Time `type:"timestamp"`

	// This parameter is no longer used.
	Time *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ScheduledUpdateGroupAction) String() string {
	return awsutil.Prettify(s)
}

// Describes information used for one or more scheduled scaling action updates
// in a BatchPutScheduledUpdateGroupAction operation.
//
// When updating a scheduled scaling action, all optional parameters are left
// unchanged if not specified.
type ScheduledUpdateGroupActionRequest struct {
	_ struct{} `type:"structure"`

	// The desired capacity is the initial capacity of the Auto Scaling group after
	// the scheduled action runs and the capacity it attempts to maintain.
	DesiredCapacity *int64 `type:"integer"`

	// The date and time for the recurring schedule to end. Amazon EC2 Auto Scaling
	// does not perform the action after this time.
	EndTime *time.Time `type:"timestamp"`

	// The maximum size of the Auto Scaling group.
	MaxSize *int64 `type:"integer"`

	// The minimum size of the Auto Scaling group.
	MinSize *int64 `type:"integer"`

	// The recurring schedule for the action, in Unix cron syntax format. This format
	// consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month]
	// [Month_of_Year] [Day_of_Week]. The value must be in quotes (for example,
	// "30 0 1 1,6,12 *"). For more information about this format, see Crontab (http://crontab.org).
	//
	// When StartTime and EndTime are specified with Recurrence, they form the boundaries
	// of when the recurring action starts and stops.
	Recurrence *string `min:"1" type:"string"`

	// The name of the scaling action.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `min:"1" type:"string" required:"true"`

	// The date and time for the action to start, in YYYY-MM-DDThh:mm:ssZ format
	// in UTC/GMT only and in quotes (for example, "2019-06-01T00:00:00Z").
	//
	// If you specify Recurrence and StartTime, Amazon EC2 Auto Scaling performs
	// the action at this time, and then performs the action based on the specified
	// recurrence.
	//
	// If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns
	// an error message.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ScheduledUpdateGroupActionRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduledUpdateGroupActionRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScheduledUpdateGroupActionRequest"}
	if s.Recurrence != nil && len(*s.Recurrence) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Recurrence", 1))
	}

	if s.ScheduledActionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScheduledActionName"))
	}
	if s.ScheduledActionName != nil && len(*s.ScheduledActionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ScheduledActionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes information used to create a step adjustment for a step scaling
// policy.
//
// For the following examples, suppose that you have an alarm with a breach
// threshold of 50:
//
//    * To trigger the adjustment when the metric is greater than or equal to
//    50 and less than 60, specify a lower bound of 0 and an upper bound of
//    10.
//
//    * To trigger the adjustment when the metric is greater than 40 and less
//    than or equal to 50, specify a lower bound of -10 and an upper bound of
//    0.
//
// There are a few rules for the step adjustments for your step policy:
//
//    * The ranges of your step adjustments can't overlap or have a gap.
//
//    * At most, one step adjustment can have a null lower bound. If one step
//    adjustment has a negative lower bound, then there must be a step adjustment
//    with a null lower bound.
//
//    * At most, one step adjustment can have a null upper bound. If one step
//    adjustment has a positive upper bound, then there must be a step adjustment
//    with a null upper bound.
//
//    * The upper and lower bound can't be null in the same step adjustment.
//
// For more information, see Step Adjustments (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-steps)
// in the Amazon EC2 Auto Scaling User Guide.
type StepAdjustment struct {
	_ struct{} `type:"structure"`

	// The lower bound for the difference between the alarm threshold and the CloudWatch
	// metric. If the metric value is above the breach threshold, the lower bound
	// is inclusive (the metric must be greater than or equal to the threshold plus
	// the lower bound). Otherwise, it is exclusive (the metric must be greater
	// than the threshold plus the lower bound). A null value indicates negative
	// infinity.
	MetricIntervalLowerBound *float64 `type:"double"`

	// The upper bound for the difference between the alarm threshold and the CloudWatch
	// metric. If the metric value is above the breach threshold, the upper bound
	// is exclusive (the metric must be less than the threshold plus the upper bound).
	// Otherwise, it is inclusive (the metric must be less than or equal to the
	// threshold plus the upper bound). A null value indicates positive infinity.
	//
	// The upper bound must be greater than the lower bound.
	MetricIntervalUpperBound *float64 `type:"double"`

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current capacity while a negative number removes from the
	// current capacity.
	//
	// ScalingAdjustment is a required field
	ScalingAdjustment *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s StepAdjustment) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StepAdjustment) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StepAdjustment"}

	if s.ScalingAdjustment == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScalingAdjustment"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an automatic scaling process that has been suspended.
//
// For more information, see Scaling Processes (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html#process-types)
// in the Amazon EC2 Auto Scaling User Guide.
type SuspendedProcess struct {
	_ struct{} `type:"structure"`

	// The name of the suspended process.
	ProcessName *string `min:"1" type:"string"`

	// The reason that the process was suspended.
	SuspensionReason *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SuspendedProcess) String() string {
	return awsutil.Prettify(s)
}

// Describes a tag for an Auto Scaling group.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Determines whether the tag is added to new instances as they are launched
	// in the group.
	PropagateAtLaunch *bool `type:"boolean"`

	// The name of the group.
	ResourceId *string `type:"string"`

	// The type of resource. The only supported value is auto-scaling-group.
	ResourceType *string `type:"string"`

	// The tag value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a tag for an Auto Scaling group.
type TagDescription struct {
	_ struct{} `type:"structure"`

	// The tag key.
	Key *string `min:"1" type:"string"`

	// Determines whether the tag is added to new instances as they are launched
	// in the group.
	PropagateAtLaunch *bool `type:"boolean"`

	// The name of the group.
	ResourceId *string `type:"string"`

	// The type of resource. The only supported value is auto-scaling-group.
	ResourceType *string `type:"string"`

	// The tag value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s TagDescription) String() string {
	return awsutil.Prettify(s)
}

// Represents a target tracking scaling policy configuration to use with Amazon
// EC2 Auto Scaling.
type TargetTrackingConfiguration struct {
	_ struct{} `type:"structure"`

	// A customized metric. You must specify either a predefined metric or a customized
	// metric.
	CustomizedMetricSpecification *CustomizedMetricSpecification `type:"structure"`

	// Indicates whether scaling in by the target tracking scaling policy is disabled.
	// If scaling in is disabled, the target tracking scaling policy doesn't remove
	// instances from the Auto Scaling group. Otherwise, the target tracking scaling
	// policy can remove instances from the Auto Scaling group. The default is false.
	DisableScaleIn *bool `type:"boolean"`

	// A predefined metric. You must specify either a predefined metric or a customized
	// metric.
	PredefinedMetricSpecification *PredefinedMetricSpecification `type:"structure"`

	// The target value for the metric.
	//
	// TargetValue is a required field
	TargetValue *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s TargetTrackingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetTrackingConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TargetTrackingConfiguration"}

	if s.TargetValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetValue"))
	}
	if s.CustomizedMetricSpecification != nil {
		if err := s.CustomizedMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("CustomizedMetricSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.PredefinedMetricSpecification != nil {
		if err := s.PredefinedMetricSpecification.Validate(); err != nil {
			invalidParams.AddNested("PredefinedMetricSpecification", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
