// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscalingplans

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateScalingPlanInput struct {
	_ struct{} `type:"structure"`

	// A CloudFormation stack or set of tags.
	ApplicationSource *ApplicationSource `type:"structure"`

	// The scaling instructions.
	ScalingInstructions []ScalingInstruction `type:"list"`

	// The name of the scaling plan.
	//
	// ScalingPlanName is a required field
	ScalingPlanName *string `min:"1" type:"string" required:"true"`

	// The version number of the scaling plan.
	//
	// ScalingPlanVersion is a required field
	ScalingPlanVersion *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s UpdateScalingPlanInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateScalingPlanInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateScalingPlanInput"}

	if s.ScalingPlanName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScalingPlanName"))
	}
	if s.ScalingPlanName != nil && len(*s.ScalingPlanName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ScalingPlanName", 1))
	}

	if s.ScalingPlanVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScalingPlanVersion"))
	}
	if s.ApplicationSource != nil {
		if err := s.ApplicationSource.Validate(); err != nil {
			invalidParams.AddNested("ApplicationSource", err.(aws.ErrInvalidParams))
		}
	}
	if s.ScalingInstructions != nil {
		for i, v := range s.ScalingInstructions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScalingInstructions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateScalingPlanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateScalingPlanOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateScalingPlan = "UpdateScalingPlan"

// UpdateScalingPlanRequest returns a request value for making API operation for
// AWS Auto Scaling Plans.
//
// Updates the specified scaling plan.
//
// You cannot update a scaling plan if it is in the process of being created,
// updated, or deleted.
//
//    // Example sending a request using UpdateScalingPlanRequest.
//    req := client.UpdateScalingPlanRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/UpdateScalingPlan
func (c *Client) UpdateScalingPlanRequest(input *UpdateScalingPlanInput) UpdateScalingPlanRequest {
	op := &aws.Operation{
		Name:       opUpdateScalingPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateScalingPlanInput{}
	}

	req := c.newRequest(op, input, &UpdateScalingPlanOutput{})

	return UpdateScalingPlanRequest{Request: req, Input: input, Copy: c.UpdateScalingPlanRequest}
}

// UpdateScalingPlanRequest is the request type for the
// UpdateScalingPlan API operation.
type UpdateScalingPlanRequest struct {
	*aws.Request
	Input *UpdateScalingPlanInput
	Copy  func(*UpdateScalingPlanInput) UpdateScalingPlanRequest
}

// Send marshals and sends the UpdateScalingPlan API request.
func (r UpdateScalingPlanRequest) Send(ctx context.Context) (*UpdateScalingPlanResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateScalingPlanResponse{
		UpdateScalingPlanOutput: r.Request.Data.(*UpdateScalingPlanOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateScalingPlanResponse is the response type for the
// UpdateScalingPlan API operation.
type UpdateScalingPlanResponse struct {
	*UpdateScalingPlanOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateScalingPlan request.
func (r *UpdateScalingPlanResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
