// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetBackupPlanFromTemplateInput struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies a stored backup plan template.
	//
	// BackupPlanTemplateId is a required field
	BackupPlanTemplateId *string `location:"uri" locationName:"templateId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBackupPlanFromTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBackupPlanFromTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetBackupPlanFromTemplateInput"}

	if s.BackupPlanTemplateId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BackupPlanTemplateId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBackupPlanFromTemplateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.BackupPlanTemplateId != nil {
		v := *s.BackupPlanTemplateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "templateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetBackupPlanFromTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Returns the body of a backup plan based on the target template, including
	// the name, rules, and backup vault of the plan.
	BackupPlanDocument *BackupPlan `type:"structure"`
}

// String returns the string representation
func (s GetBackupPlanFromTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetBackupPlanFromTemplateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackupPlanDocument != nil {
		v := s.BackupPlanDocument

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "BackupPlanDocument", v, metadata)
	}
	return nil
}

const opGetBackupPlanFromTemplate = "GetBackupPlanFromTemplate"

// GetBackupPlanFromTemplateRequest returns a request value for making API operation for
// AWS Backup.
//
// Returns the template specified by its templateId as a backup plan.
//
//    // Example sending a request using GetBackupPlanFromTemplateRequest.
//    req := client.GetBackupPlanFromTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromTemplate
func (c *Client) GetBackupPlanFromTemplateRequest(input *GetBackupPlanFromTemplateInput) GetBackupPlanFromTemplateRequest {
	op := &aws.Operation{
		Name:       opGetBackupPlanFromTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/backup/template/plans/{templateId}/toPlan",
	}

	if input == nil {
		input = &GetBackupPlanFromTemplateInput{}
	}

	req := c.newRequest(op, input, &GetBackupPlanFromTemplateOutput{})

	return GetBackupPlanFromTemplateRequest{Request: req, Input: input, Copy: c.GetBackupPlanFromTemplateRequest}
}

// GetBackupPlanFromTemplateRequest is the request type for the
// GetBackupPlanFromTemplate API operation.
type GetBackupPlanFromTemplateRequest struct {
	*aws.Request
	Input *GetBackupPlanFromTemplateInput
	Copy  func(*GetBackupPlanFromTemplateInput) GetBackupPlanFromTemplateRequest
}

// Send marshals and sends the GetBackupPlanFromTemplate API request.
func (r GetBackupPlanFromTemplateRequest) Send(ctx context.Context) (*GetBackupPlanFromTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetBackupPlanFromTemplateResponse{
		GetBackupPlanFromTemplateOutput: r.Request.Data.(*GetBackupPlanFromTemplateOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetBackupPlanFromTemplateResponse is the response type for the
// GetBackupPlanFromTemplate API operation.
type GetBackupPlanFromTemplateResponse struct {
	*GetBackupPlanFromTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetBackupPlanFromTemplate request.
func (r *GetBackupPlanFromTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
