// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListRestoreJobsInput struct {
	_ struct{} `type:"structure"`

	// The account ID to list the jobs from. Returns only restore jobs associated
	// with the specified account ID.
	ByAccountId *string `location:"querystring" locationName:"accountId" type:"string"`

	// Returns only restore jobs that were created after the specified date.
	ByCreatedAfter *time.Time `location:"querystring" locationName:"createdAfter" type:"timestamp"`

	// Returns only restore jobs that were created before the specified date.
	ByCreatedBefore *time.Time `location:"querystring" locationName:"createdBefore" type:"timestamp"`

	// Returns only restore jobs associated with the specified job status.
	ByStatus RestoreJobStatus `location:"querystring" locationName:"status" type:"string" enum:"true"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return maxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListRestoreJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRestoreJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListRestoreJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRestoreJobsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ByAccountId != nil {
		v := *s.ByAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ByCreatedAfter != nil {
		v := *s.ByCreatedAfter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "createdAfter",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if s.ByCreatedBefore != nil {
		v := *s.ByCreatedBefore

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "createdBefore",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if len(s.ByStatus) > 0 {
		v := s.ByStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListRestoreJobsOutput struct {
	_ struct{} `type:"structure"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return maxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`

	// An array of objects that contain detailed information about jobs to restore
	// saved resources.
	RestoreJobs []RestoreJobsListMember `type:"list"`
}

// String returns the string representation
func (s ListRestoreJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRestoreJobsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RestoreJobs != nil {
		v := s.RestoreJobs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RestoreJobs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListRestoreJobs = "ListRestoreJobs"

// ListRestoreJobsRequest returns a request value for making API operation for
// AWS Backup.
//
// Returns a list of jobs that AWS Backup initiated to restore a saved resource,
// including metadata about the recovery process.
//
//    // Example sending a request using ListRestoreJobsRequest.
//    req := client.ListRestoreJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs
func (c *Client) ListRestoreJobsRequest(input *ListRestoreJobsInput) ListRestoreJobsRequest {
	op := &aws.Operation{
		Name:       opListRestoreJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/restore-jobs/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRestoreJobsInput{}
	}

	req := c.newRequest(op, input, &ListRestoreJobsOutput{})

	return ListRestoreJobsRequest{Request: req, Input: input, Copy: c.ListRestoreJobsRequest}
}

// ListRestoreJobsRequest is the request type for the
// ListRestoreJobs API operation.
type ListRestoreJobsRequest struct {
	*aws.Request
	Input *ListRestoreJobsInput
	Copy  func(*ListRestoreJobsInput) ListRestoreJobsRequest
}

// Send marshals and sends the ListRestoreJobs API request.
func (r ListRestoreJobsRequest) Send(ctx context.Context) (*ListRestoreJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListRestoreJobsResponse{
		ListRestoreJobsOutput: r.Request.Data.(*ListRestoreJobsOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListRestoreJobsRequestPaginator returns a paginator for ListRestoreJobs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListRestoreJobsRequest(input)
//   p := backup.NewListRestoreJobsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListRestoreJobsPaginator(req ListRestoreJobsRequest) ListRestoreJobsPaginator {
	return ListRestoreJobsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListRestoreJobsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListRestoreJobsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListRestoreJobsPaginator struct {
	aws.Pager
}

func (p *ListRestoreJobsPaginator) CurrentPage() *ListRestoreJobsOutput {
	return p.Pager.CurrentPage().(*ListRestoreJobsOutput)
}

// ListRestoreJobsResponse is the response type for the
// ListRestoreJobs API operation.
type ListRestoreJobsResponse struct {
	*ListRestoreJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListRestoreJobs request.
func (r *ListRestoreJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
