// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type StartCopyJobInput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a destination backup
	// vault to copy to; for example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	//
	// DestinationBackupVaultArn is a required field
	DestinationBackupVaultArn *string `type:"string" required:"true"`

	// Specifies the IAM role ARN used to copy the target recovery point; for example,
	// arn:aws:iam::123456789012:role/S3Access.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `type:"string" required:"true"`

	// A customer chosen string that can be used to distinguish between calls to
	// StartCopyJob.
	IdempotencyToken *string `type:"string"`

	// Contains an array of Transition objects specifying how long in days before
	// a recovery point transitions to cold storage or is deleted.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days. Therefore, on the console, the “expire after days”
	// setting must be 90 days greater than the “transition to cold after days”
	// setting. The “transition to cold after days” setting cannot be changed
	// after a backup has been transitioned to cold.
	Lifecycle *Lifecycle `type:"structure"`

	// An ARN that uniquely identifies a recovery point to use for the copy job;
	// for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	//
	// RecoveryPointArn is a required field
	RecoveryPointArn *string `type:"string" required:"true"`

	// The name of a logical source container where backups are stored. Backup vaults
	// are identified by names that are unique to the account used to create them
	// and the AWS Region where they are created. They consist of lowercase letters,
	// numbers, and hyphens.
	//
	// SourceBackupVaultName is a required field
	SourceBackupVaultName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartCopyJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartCopyJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartCopyJobInput"}

	if s.DestinationBackupVaultArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationBackupVaultArn"))
	}

	if s.IamRoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("IamRoleArn"))
	}

	if s.RecoveryPointArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecoveryPointArn"))
	}

	if s.SourceBackupVaultName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceBackupVaultName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartCopyJobInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DestinationBackupVaultArn != nil {
		v := *s.DestinationBackupVaultArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationBackupVaultArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IamRoleArn != nil {
		v := *s.IamRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IamRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IdempotencyToken != nil {
		v := *s.IdempotencyToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IdempotencyToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Lifecycle != nil {
		v := s.Lifecycle

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Lifecycle", v, metadata)
	}
	if s.RecoveryPointArn != nil {
		v := *s.RecoveryPointArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecoveryPointArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceBackupVaultName != nil {
		v := *s.SourceBackupVaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceBackupVaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type StartCopyJobOutput struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies a copy job.
	CopyJobId *string `type:"string"`

	// The date and time that a copy job is started, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s StartCopyJobOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartCopyJobOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CopyJobId != nil {
		v := *s.CopyJobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CopyJobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

const opStartCopyJob = "StartCopyJob"

// StartCopyJobRequest returns a request value for making API operation for
// AWS Backup.
//
// Starts a job to create a one-time copy of the specified resource.
//
//    // Example sending a request using StartCopyJobRequest.
//    req := client.StartCopyJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartCopyJob
func (c *Client) StartCopyJobRequest(input *StartCopyJobInput) StartCopyJobRequest {
	op := &aws.Operation{
		Name:       opStartCopyJob,
		HTTPMethod: "PUT",
		HTTPPath:   "/copy-jobs",
	}

	if input == nil {
		input = &StartCopyJobInput{}
	}

	req := c.newRequest(op, input, &StartCopyJobOutput{})

	return StartCopyJobRequest{Request: req, Input: input, Copy: c.StartCopyJobRequest}
}

// StartCopyJobRequest is the request type for the
// StartCopyJob API operation.
type StartCopyJobRequest struct {
	*aws.Request
	Input *StartCopyJobInput
	Copy  func(*StartCopyJobInput) StartCopyJobRequest
}

// Send marshals and sends the StartCopyJob API request.
func (r StartCopyJobRequest) Send(ctx context.Context) (*StartCopyJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartCopyJobResponse{
		StartCopyJobOutput: r.Request.Data.(*StartCopyJobOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartCopyJobResponse is the response type for the
// StartCopyJob API operation.
type StartCopyJobResponse struct {
	*StartCopyJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartCopyJob request.
func (r *StartCopyJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
