// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type StartRestoreJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that AWS Backup uses to create
	// the target recovery point; for example, arn:aws:iam::123456789012:role/S3Access.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `type:"string" required:"true"`

	// A customer chosen string that can be used to distinguish between calls to
	// StartRestoreJob.
	IdempotencyToken *string `type:"string"`

	// A set of metadata key-value pairs. Contains information, such as a resource
	// name, required to restore a recovery point.
	//
	// You can get configuration metadata about a resource at the time it was backed
	// up by calling GetRecoveryPointRestoreMetadata. However, values in addition
	// to those provided by GetRecoveryPointRestoreMetadata might be required to
	// restore a resource. For example, you might need to provide a new resource
	// name if the original already exists.
	//
	// You need to specify specific metadata to restore an Amazon Elastic File System
	// (Amazon EFS) instance:
	//
	//    * file-system-id: ID of the Amazon EFS file system that is backed up by
	//    AWS Backup. Returned in GetRecoveryPointRestoreMetadata.
	//
	//    * Encrypted: A Boolean value that, if true, specifies that the file system
	//    is encrypted. If KmsKeyId is specified, Encrypted must be set to true.
	//
	//    * KmsKeyId: Specifies the AWS KMS key that is used to encrypt the restored
	//    file system.
	//
	//    * PerformanceMode: Specifies the throughput mode of the file system.
	//
	//    * CreationToken: A user-supplied value that ensures the uniqueness (idempotency)
	//    of the request.
	//
	//    * newFileSystem: A Boolean value that, if true, specifies that the recovery
	//    point is restored to a new Amazon EFS file system.
	//
	// Metadata is a required field
	Metadata map[string]string `type:"map" required:"true" sensitive:"true"`

	// An ARN that uniquely identifies a recovery point; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	//
	// RecoveryPointArn is a required field
	RecoveryPointArn *string `type:"string" required:"true"`

	// Starts a job to restore a recovery point for one of the following resources:
	//
	//    * DynamoDB for Amazon DynamoDB
	//
	//    * EBS for Amazon Elastic Block Store
	//
	//    * EC2 for Amazon Elastic Compute Cloud
	//
	//    * EFS for Amazon Elastic File System
	//
	//    * RDS for Amazon Relational Database Service
	//
	//    * Storage Gateway for AWS Storage Gateway
	ResourceType *string `type:"string"`
}

// String returns the string representation
func (s StartRestoreJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartRestoreJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartRestoreJobInput"}

	if s.IamRoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("IamRoleArn"))
	}

	if s.Metadata == nil {
		invalidParams.Add(aws.NewErrParamRequired("Metadata"))
	}

	if s.RecoveryPointArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecoveryPointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartRestoreJobInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.IamRoleArn != nil {
		v := *s.IamRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IamRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IdempotencyToken != nil {
		v := *s.IdempotencyToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IdempotencyToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Metadata != nil {
		v := s.Metadata

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Metadata", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.RecoveryPointArn != nil {
		v := *s.RecoveryPointArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecoveryPointArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceType != nil {
		v := *s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type StartRestoreJobOutput struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies the job that restores a recovery point.
	RestoreJobId *string `type:"string"`
}

// String returns the string representation
func (s StartRestoreJobOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartRestoreJobOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RestoreJobId != nil {
		v := *s.RestoreJobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RestoreJobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opStartRestoreJob = "StartRestoreJob"

// StartRestoreJobRequest returns a request value for making API operation for
// AWS Backup.
//
// Recovers the saved resource identified by an Amazon Resource Name (ARN).
//
// If the resource ARN is included in the request, then the last complete backup
// of that resource is recovered. If the ARN of a recovery point is supplied,
// then that recovery point is restored.
//
//    // Example sending a request using StartRestoreJobRequest.
//    req := client.StartRestoreJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartRestoreJob
func (c *Client) StartRestoreJobRequest(input *StartRestoreJobInput) StartRestoreJobRequest {
	op := &aws.Operation{
		Name:       opStartRestoreJob,
		HTTPMethod: "PUT",
		HTTPPath:   "/restore-jobs",
	}

	if input == nil {
		input = &StartRestoreJobInput{}
	}

	req := c.newRequest(op, input, &StartRestoreJobOutput{})

	return StartRestoreJobRequest{Request: req, Input: input, Copy: c.StartRestoreJobRequest}
}

// StartRestoreJobRequest is the request type for the
// StartRestoreJob API operation.
type StartRestoreJobRequest struct {
	*aws.Request
	Input *StartRestoreJobInput
	Copy  func(*StartRestoreJobInput) StartRestoreJobRequest
}

// Send marshals and sends the StartRestoreJob API request.
func (r StartRestoreJobRequest) Send(ctx context.Context) (*StartRestoreJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartRestoreJobResponse{
		StartRestoreJobOutput: r.Request.Data.(*StartRestoreJobOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartRestoreJobResponse is the response type for the
// StartRestoreJob API operation.
type StartRestoreJobResponse struct {
	*StartRestoreJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartRestoreJob request.
func (r *StartRestoreJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
