// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type UpdateRegionSettingsInput struct {
	_ struct{} `type:"structure"`

	// Updates the list of services along with the opt-in preferences for the region.
	ResourceTypeOptInPreference map[string]bool `type:"map"`
}

// String returns the string representation
func (s UpdateRegionSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRegionSettingsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ResourceTypeOptInPreference != nil {
		v := s.ResourceTypeOptInPreference

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "ResourceTypeOptInPreference", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.BoolValue(v1))
		}
		ms0.End()

	}
	return nil
}

type UpdateRegionSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRegionSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRegionSettingsOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateRegionSettings = "UpdateRegionSettings"

// UpdateRegionSettingsRequest returns a request value for making API operation for
// AWS Backup.
//
// Updates the current service opt-in settings for the Region. If the service
// has a value set to true, AWS Backup attempts to protect that service's resources
// in this Region, when included in an on-demand backup or scheduled backup
// plan. If the value is set to false for a service, AWS Backup does not attempt
// to protect that service's resources in this Region.
//
//    // Example sending a request using UpdateRegionSettingsRequest.
//    req := client.UpdateRegionSettingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRegionSettings
func (c *Client) UpdateRegionSettingsRequest(input *UpdateRegionSettingsInput) UpdateRegionSettingsRequest {
	op := &aws.Operation{
		Name:       opUpdateRegionSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/account-settings",
	}

	if input == nil {
		input = &UpdateRegionSettingsInput{}
	}

	req := c.newRequest(op, input, &UpdateRegionSettingsOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return UpdateRegionSettingsRequest{Request: req, Input: input, Copy: c.UpdateRegionSettingsRequest}
}

// UpdateRegionSettingsRequest is the request type for the
// UpdateRegionSettings API operation.
type UpdateRegionSettingsRequest struct {
	*aws.Request
	Input *UpdateRegionSettingsInput
	Copy  func(*UpdateRegionSettingsInput) UpdateRegionSettingsRequest
}

// Send marshals and sends the UpdateRegionSettings API request.
func (r UpdateRegionSettingsRequest) Send(ctx context.Context) (*UpdateRegionSettingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRegionSettingsResponse{
		UpdateRegionSettingsOutput: r.Request.Data.(*UpdateRegionSettingsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRegionSettingsResponse is the response type for the
// UpdateRegionSettings API operation.
type UpdateRegionSettingsResponse struct {
	*UpdateRegionSettingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRegionSettings request.
func (r *UpdateRegionSettingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
