// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package batch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeregisterJobDefinitionInput struct {
	_ struct{} `type:"structure"`

	// The name and revision (name:revision) or full Amazon Resource Name (ARN)
	// of the job definition to deregister.
	//
	// JobDefinition is a required field
	JobDefinition *string `locationName:"jobDefinition" type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterJobDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterJobDefinitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeregisterJobDefinitionInput"}

	if s.JobDefinition == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobDefinition"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeregisterJobDefinitionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.JobDefinition != nil {
		v := *s.JobDefinition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobDefinition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeregisterJobDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterJobDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeregisterJobDefinitionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeregisterJobDefinition = "DeregisterJobDefinition"

// DeregisterJobDefinitionRequest returns a request value for making API operation for
// AWS Batch.
//
// Deregisters an AWS Batch job definition. Job definitions will be permanently
// deleted after 180 days.
//
//    // Example sending a request using DeregisterJobDefinitionRequest.
//    req := client.DeregisterJobDefinitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/DeregisterJobDefinition
func (c *Client) DeregisterJobDefinitionRequest(input *DeregisterJobDefinitionInput) DeregisterJobDefinitionRequest {
	op := &aws.Operation{
		Name:       opDeregisterJobDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/deregisterjobdefinition",
	}

	if input == nil {
		input = &DeregisterJobDefinitionInput{}
	}

	req := c.newRequest(op, input, &DeregisterJobDefinitionOutput{})

	return DeregisterJobDefinitionRequest{Request: req, Input: input, Copy: c.DeregisterJobDefinitionRequest}
}

// DeregisterJobDefinitionRequest is the request type for the
// DeregisterJobDefinition API operation.
type DeregisterJobDefinitionRequest struct {
	*aws.Request
	Input *DeregisterJobDefinitionInput
	Copy  func(*DeregisterJobDefinitionInput) DeregisterJobDefinitionRequest
}

// Send marshals and sends the DeregisterJobDefinition API request.
func (r DeregisterJobDefinitionRequest) Send(ctx context.Context) (*DeregisterJobDefinitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeregisterJobDefinitionResponse{
		DeregisterJobDefinitionOutput: r.Request.Data.(*DeregisterJobDefinitionOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeregisterJobDefinitionResponse is the response type for the
// DeregisterJobDefinition API operation.
type DeregisterJobDefinitionResponse struct {
	*DeregisterJobDefinitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeregisterJobDefinition request.
func (r *DeregisterJobDefinitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
