// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package budgets

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Request of CreateBudget
type CreateBudgetInput struct {
	_ struct{} `type:"structure"`

	// The accountId that is associated with the budget.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The budget object that you want to create.
	//
	// Budget is a required field
	Budget *Budget `type:"structure" required:"true"`

	// A notification that you want to associate with a budget. A budget can have
	// up to five notifications, and each notification can have one SNS subscriber
	// and up to 10 email subscribers. If you include notifications and subscribers
	// in your CreateBudget call, AWS creates the notifications and subscribers
	// for you.
	NotificationsWithSubscribers []NotificationWithSubscribers `type:"list"`
}

// String returns the string representation
func (s CreateBudgetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBudgetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateBudgetInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AccountId", 12))
	}

	if s.Budget == nil {
		invalidParams.Add(aws.NewErrParamRequired("Budget"))
	}
	if s.Budget != nil {
		if err := s.Budget.Validate(); err != nil {
			invalidParams.AddNested("Budget", err.(aws.ErrInvalidParams))
		}
	}
	if s.NotificationsWithSubscribers != nil {
		for i, v := range s.NotificationsWithSubscribers {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NotificationsWithSubscribers", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Response of CreateBudget
type CreateBudgetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateBudgetOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateBudget = "CreateBudget"

// CreateBudgetRequest returns a request value for making API operation for
// AWS Budgets.
//
// Creates a budget and, if included, notifications and subscribers.
//
// Only one of BudgetLimit or PlannedBudgetLimits can be present in the syntax
// at one time. Use the syntax that matches your case. The Request Syntax section
// shows the BudgetLimit syntax. For PlannedBudgetLimits, see the Examples (https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_budgets_CreateBudget.html#API_CreateBudget_Examples)
// section.
//
//    // Example sending a request using CreateBudgetRequest.
//    req := client.CreateBudgetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CreateBudgetRequest(input *CreateBudgetInput) CreateBudgetRequest {
	op := &aws.Operation{
		Name:       opCreateBudget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBudgetInput{}
	}

	req := c.newRequest(op, input, &CreateBudgetOutput{})

	return CreateBudgetRequest{Request: req, Input: input, Copy: c.CreateBudgetRequest}
}

// CreateBudgetRequest is the request type for the
// CreateBudget API operation.
type CreateBudgetRequest struct {
	*aws.Request
	Input *CreateBudgetInput
	Copy  func(*CreateBudgetInput) CreateBudgetRequest
}

// Send marshals and sends the CreateBudget API request.
func (r CreateBudgetRequest) Send(ctx context.Context) (*CreateBudgetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateBudgetResponse{
		CreateBudgetOutput: r.Request.Data.(*CreateBudgetOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateBudgetResponse is the response type for the
// CreateBudget API operation.
type CreateBudgetResponse struct {
	*CreateBudgetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateBudget request.
func (r *CreateBudgetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
