// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package budgets

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Request of DescribeNotificationsForBudget
type DescribeNotificationsForBudgetInput struct {
	_ struct{} `type:"structure"`

	// The accountId that is associated with the budget whose notifications you
	// want descriptions of.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The name of the budget whose notifications you want descriptions of.
	//
	// BudgetName is a required field
	BudgetName *string `min:"1" type:"string" required:"true"`

	// An optional integer that represents how many entries a paginated response
	// contains. The maximum is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token that you include in your request to indicate the next
	// set of results that you want to retrieve.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeNotificationsForBudgetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNotificationsForBudgetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeNotificationsForBudgetInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AccountId", 12))
	}

	if s.BudgetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BudgetName"))
	}
	if s.BudgetName != nil && len(*s.BudgetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BudgetName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Response of GetNotificationsForBudget
type DescribeNotificationsForBudgetOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token in the service response that indicates the next set
	// of results that you can retrieve.
	NextToken *string `type:"string"`

	// A list of notifications that are associated with a budget.
	Notifications []Notification `type:"list"`
}

// String returns the string representation
func (s DescribeNotificationsForBudgetOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeNotificationsForBudget = "DescribeNotificationsForBudget"

// DescribeNotificationsForBudgetRequest returns a request value for making API operation for
// AWS Budgets.
//
// Lists the notifications that are associated with a budget.
//
//    // Example sending a request using DescribeNotificationsForBudgetRequest.
//    req := client.DescribeNotificationsForBudgetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeNotificationsForBudgetRequest(input *DescribeNotificationsForBudgetInput) DescribeNotificationsForBudgetRequest {
	op := &aws.Operation{
		Name:       opDescribeNotificationsForBudget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNotificationsForBudgetInput{}
	}

	req := c.newRequest(op, input, &DescribeNotificationsForBudgetOutput{})

	return DescribeNotificationsForBudgetRequest{Request: req, Input: input, Copy: c.DescribeNotificationsForBudgetRequest}
}

// DescribeNotificationsForBudgetRequest is the request type for the
// DescribeNotificationsForBudget API operation.
type DescribeNotificationsForBudgetRequest struct {
	*aws.Request
	Input *DescribeNotificationsForBudgetInput
	Copy  func(*DescribeNotificationsForBudgetInput) DescribeNotificationsForBudgetRequest
}

// Send marshals and sends the DescribeNotificationsForBudget API request.
func (r DescribeNotificationsForBudgetRequest) Send(ctx context.Context) (*DescribeNotificationsForBudgetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeNotificationsForBudgetResponse{
		DescribeNotificationsForBudgetOutput: r.Request.Data.(*DescribeNotificationsForBudgetOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeNotificationsForBudgetResponse is the response type for the
// DescribeNotificationsForBudget API operation.
type DescribeNotificationsForBudgetResponse struct {
	*DescribeNotificationsForBudgetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeNotificationsForBudget request.
func (r *DescribeNotificationsForBudgetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
