// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetRetentionSettingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRetentionSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRetentionSettingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetRetentionSettingsInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRetentionSettingsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetRetentionSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp representing the time at which the specified items are permanently
	// deleted, in ISO 8601 format.
	InitiateDeletionTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The retention settings.
	RetentionSettings *RetentionSettings `type:"structure"`
}

// String returns the string representation
func (s GetRetentionSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetRetentionSettingsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.InitiateDeletionTimestamp != nil {
		v := *s.InitiateDeletionTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InitiateDeletionTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.RetentionSettings != nil {
		v := s.RetentionSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RetentionSettings", v, metadata)
	}
	return nil
}

const opGetRetentionSettings = "GetRetentionSettings"

// GetRetentionSettingsRequest returns a request value for making API operation for
// Amazon Chime.
//
// Gets the retention settings for the specified Amazon Chime Enterprise account.
// For more information about retention settings, see Managing Chat Retention
// Policies (https://docs.aws.amazon.com/chime/latest/ag/chat-retention.html)
// in the Amazon Chime Administration Guide.
//
//    // Example sending a request using GetRetentionSettingsRequest.
//    req := client.GetRetentionSettingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetRetentionSettings
func (c *Client) GetRetentionSettingsRequest(input *GetRetentionSettingsInput) GetRetentionSettingsRequest {
	op := &aws.Operation{
		Name:       opGetRetentionSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/retention-settings",
	}

	if input == nil {
		input = &GetRetentionSettingsInput{}
	}

	req := c.newRequest(op, input, &GetRetentionSettingsOutput{})

	return GetRetentionSettingsRequest{Request: req, Input: input, Copy: c.GetRetentionSettingsRequest}
}

// GetRetentionSettingsRequest is the request type for the
// GetRetentionSettings API operation.
type GetRetentionSettingsRequest struct {
	*aws.Request
	Input *GetRetentionSettingsInput
	Copy  func(*GetRetentionSettingsInput) GetRetentionSettingsRequest
}

// Send marshals and sends the GetRetentionSettings API request.
func (r GetRetentionSettingsRequest) Send(ctx context.Context) (*GetRetentionSettingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRetentionSettingsResponse{
		GetRetentionSettingsOutput: r.Request.Data.(*GetRetentionSettingsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRetentionSettingsResponse is the response type for the
// GetRetentionSettings API operation.
type GetRetentionSettingsResponse struct {
	*GetRetentionSettingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRetentionSettings request.
func (r *GetRetentionSettingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
