// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetVoiceConnectorEmergencyCallingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVoiceConnectorEmergencyCallingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorEmergencyCallingConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetVoiceConnectorEmergencyCallingConfigurationInput"}

	if s.VoiceConnectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VoiceConnectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetVoiceConnectorEmergencyCallingConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.VoiceConnectorId != nil {
		v := *s.VoiceConnectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "voiceConnectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetVoiceConnectorEmergencyCallingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The emergency calling configuration details.
	EmergencyCallingConfiguration *EmergencyCallingConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetVoiceConnectorEmergencyCallingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetVoiceConnectorEmergencyCallingConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.EmergencyCallingConfiguration != nil {
		v := s.EmergencyCallingConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "EmergencyCallingConfiguration", v, metadata)
	}
	return nil
}

const opGetVoiceConnectorEmergencyCallingConfiguration = "GetVoiceConnectorEmergencyCallingConfiguration"

// GetVoiceConnectorEmergencyCallingConfigurationRequest returns a request value for making API operation for
// Amazon Chime.
//
// Gets the emergency calling configuration details for the specified Amazon
// Chime Voice Connector.
//
//    // Example sending a request using GetVoiceConnectorEmergencyCallingConfigurationRequest.
//    req := client.GetVoiceConnectorEmergencyCallingConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorEmergencyCallingConfiguration
func (c *Client) GetVoiceConnectorEmergencyCallingConfigurationRequest(input *GetVoiceConnectorEmergencyCallingConfigurationInput) GetVoiceConnectorEmergencyCallingConfigurationRequest {
	op := &aws.Operation{
		Name:       opGetVoiceConnectorEmergencyCallingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/emergency-calling-configuration",
	}

	if input == nil {
		input = &GetVoiceConnectorEmergencyCallingConfigurationInput{}
	}

	req := c.newRequest(op, input, &GetVoiceConnectorEmergencyCallingConfigurationOutput{})

	return GetVoiceConnectorEmergencyCallingConfigurationRequest{Request: req, Input: input, Copy: c.GetVoiceConnectorEmergencyCallingConfigurationRequest}
}

// GetVoiceConnectorEmergencyCallingConfigurationRequest is the request type for the
// GetVoiceConnectorEmergencyCallingConfiguration API operation.
type GetVoiceConnectorEmergencyCallingConfigurationRequest struct {
	*aws.Request
	Input *GetVoiceConnectorEmergencyCallingConfigurationInput
	Copy  func(*GetVoiceConnectorEmergencyCallingConfigurationInput) GetVoiceConnectorEmergencyCallingConfigurationRequest
}

// Send marshals and sends the GetVoiceConnectorEmergencyCallingConfiguration API request.
func (r GetVoiceConnectorEmergencyCallingConfigurationRequest) Send(ctx context.Context) (*GetVoiceConnectorEmergencyCallingConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetVoiceConnectorEmergencyCallingConfigurationResponse{
		GetVoiceConnectorEmergencyCallingConfigurationOutput: r.Request.Data.(*GetVoiceConnectorEmergencyCallingConfigurationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetVoiceConnectorEmergencyCallingConfigurationResponse is the response type for the
// GetVoiceConnectorEmergencyCallingConfiguration API operation.
type GetVoiceConnectorEmergencyCallingConfigurationResponse struct {
	*GetVoiceConnectorEmergencyCallingConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetVoiceConnectorEmergencyCallingConfiguration request.
func (r *GetVoiceConnectorEmergencyCallingConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
