// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetVoiceConnectorLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVoiceConnectorLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorLoggingConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetVoiceConnectorLoggingConfigurationInput"}

	if s.VoiceConnectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VoiceConnectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetVoiceConnectorLoggingConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.VoiceConnectorId != nil {
		v := *s.VoiceConnectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "voiceConnectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetVoiceConnectorLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The logging configuration details.
	LoggingConfiguration *LoggingConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetVoiceConnectorLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetVoiceConnectorLoggingConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.LoggingConfiguration != nil {
		v := s.LoggingConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LoggingConfiguration", v, metadata)
	}
	return nil
}

const opGetVoiceConnectorLoggingConfiguration = "GetVoiceConnectorLoggingConfiguration"

// GetVoiceConnectorLoggingConfigurationRequest returns a request value for making API operation for
// Amazon Chime.
//
// Retrieves the logging configuration details for the specified Amazon Chime
// Voice Connector. Shows whether SIP message logs are enabled for sending to
// Amazon CloudWatch Logs.
//
//    // Example sending a request using GetVoiceConnectorLoggingConfigurationRequest.
//    req := client.GetVoiceConnectorLoggingConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorLoggingConfiguration
func (c *Client) GetVoiceConnectorLoggingConfigurationRequest(input *GetVoiceConnectorLoggingConfigurationInput) GetVoiceConnectorLoggingConfigurationRequest {
	op := &aws.Operation{
		Name:       opGetVoiceConnectorLoggingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/logging-configuration",
	}

	if input == nil {
		input = &GetVoiceConnectorLoggingConfigurationInput{}
	}

	req := c.newRequest(op, input, &GetVoiceConnectorLoggingConfigurationOutput{})

	return GetVoiceConnectorLoggingConfigurationRequest{Request: req, Input: input, Copy: c.GetVoiceConnectorLoggingConfigurationRequest}
}

// GetVoiceConnectorLoggingConfigurationRequest is the request type for the
// GetVoiceConnectorLoggingConfiguration API operation.
type GetVoiceConnectorLoggingConfigurationRequest struct {
	*aws.Request
	Input *GetVoiceConnectorLoggingConfigurationInput
	Copy  func(*GetVoiceConnectorLoggingConfigurationInput) GetVoiceConnectorLoggingConfigurationRequest
}

// Send marshals and sends the GetVoiceConnectorLoggingConfiguration API request.
func (r GetVoiceConnectorLoggingConfigurationRequest) Send(ctx context.Context) (*GetVoiceConnectorLoggingConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetVoiceConnectorLoggingConfigurationResponse{
		GetVoiceConnectorLoggingConfigurationOutput: r.Request.Data.(*GetVoiceConnectorLoggingConfigurationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetVoiceConnectorLoggingConfigurationResponse is the response type for the
// GetVoiceConnectorLoggingConfiguration API operation.
type GetVoiceConnectorLoggingConfigurationResponse struct {
	*GetVoiceConnectorLoggingConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetVoiceConnectorLoggingConfiguration request.
func (r *GetVoiceConnectorLoggingConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
