// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetVoiceConnectorProxyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime voice connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVoiceConnectorProxyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorProxyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetVoiceConnectorProxyInput"}

	if s.VoiceConnectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetVoiceConnectorProxyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.VoiceConnectorId != nil {
		v := *s.VoiceConnectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "voiceConnectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetVoiceConnectorProxyOutput struct {
	_ struct{} `type:"structure"`

	// The proxy configuration details.
	Proxy *Proxy `type:"structure"`
}

// String returns the string representation
func (s GetVoiceConnectorProxyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetVoiceConnectorProxyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Proxy != nil {
		v := s.Proxy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Proxy", v, metadata)
	}
	return nil
}

const opGetVoiceConnectorProxy = "GetVoiceConnectorProxy"

// GetVoiceConnectorProxyRequest returns a request value for making API operation for
// Amazon Chime.
//
// Gets the proxy configuration details for the specified Amazon Chime Voice
// Connector.
//
//    // Example sending a request using GetVoiceConnectorProxyRequest.
//    req := client.GetVoiceConnectorProxyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorProxy
func (c *Client) GetVoiceConnectorProxyRequest(input *GetVoiceConnectorProxyInput) GetVoiceConnectorProxyRequest {
	op := &aws.Operation{
		Name:       opGetVoiceConnectorProxy,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/programmable-numbers/proxy",
	}

	if input == nil {
		input = &GetVoiceConnectorProxyInput{}
	}

	req := c.newRequest(op, input, &GetVoiceConnectorProxyOutput{})

	return GetVoiceConnectorProxyRequest{Request: req, Input: input, Copy: c.GetVoiceConnectorProxyRequest}
}

// GetVoiceConnectorProxyRequest is the request type for the
// GetVoiceConnectorProxy API operation.
type GetVoiceConnectorProxyRequest struct {
	*aws.Request
	Input *GetVoiceConnectorProxyInput
	Copy  func(*GetVoiceConnectorProxyInput) GetVoiceConnectorProxyRequest
}

// Send marshals and sends the GetVoiceConnectorProxy API request.
func (r GetVoiceConnectorProxyRequest) Send(ctx context.Context) (*GetVoiceConnectorProxyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetVoiceConnectorProxyResponse{
		GetVoiceConnectorProxyOutput: r.Request.Data.(*GetVoiceConnectorProxyOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetVoiceConnectorProxyResponse is the response type for the
// GetVoiceConnectorProxy API operation.
type GetVoiceConnectorProxyResponse struct {
	*GetVoiceConnectorProxyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetVoiceConnectorProxy request.
func (r *GetVoiceConnectorProxyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
