// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type InviteUsersInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The user email addresses to which to send the email invitation.
	//
	// UserEmailList is a required field
	UserEmailList []string `type:"list" required:"true"`

	// The user type.
	UserType UserType `type:"string" enum:"true"`
}

// String returns the string representation
func (s InviteUsersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InviteUsersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InviteUsersInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.UserEmailList == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserEmailList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InviteUsersInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.UserEmailList != nil {
		v := s.UserEmailList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "UserEmailList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.UserType) > 0 {
		v := s.UserType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type InviteUsersOutput struct {
	_ struct{} `type:"structure"`

	// The email invitation details.
	Invites []Invite `type:"list"`
}

// String returns the string representation
func (s InviteUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InviteUsersOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Invites != nil {
		v := s.Invites

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Invites", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opInviteUsers = "InviteUsers"

// InviteUsersRequest returns a request value for making API operation for
// Amazon Chime.
//
// Sends email to a maximum of 50 users, inviting them to the specified Amazon
// Chime Team account. Only Team account types are currently supported for this
// action.
//
//    // Example sending a request using InviteUsersRequest.
//    req := client.InviteUsersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/InviteUsers
func (c *Client) InviteUsersRequest(input *InviteUsersInput) InviteUsersRequest {
	op := &aws.Operation{
		Name:       opInviteUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users?operation=add",
	}

	if input == nil {
		input = &InviteUsersInput{}
	}

	req := c.newRequest(op, input, &InviteUsersOutput{})

	return InviteUsersRequest{Request: req, Input: input, Copy: c.InviteUsersRequest}
}

// InviteUsersRequest is the request type for the
// InviteUsers API operation.
type InviteUsersRequest struct {
	*aws.Request
	Input *InviteUsersInput
	Copy  func(*InviteUsersInput) InviteUsersRequest
}

// Send marshals and sends the InviteUsers API request.
func (r InviteUsersRequest) Send(ctx context.Context) (*InviteUsersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &InviteUsersResponse{
		InviteUsersOutput: r.Request.Data.(*InviteUsersOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// InviteUsersResponse is the response type for the
// InviteUsers API operation.
type InviteUsersResponse struct {
	*InviteUsersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// InviteUsers request.
func (r *InviteUsersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
