// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListVoiceConnectorGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListVoiceConnectorGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVoiceConnectorGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListVoiceConnectorGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListVoiceConnectorGroupsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-results", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListVoiceConnectorGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`

	// The details of the Amazon Chime Voice Connector groups.
	VoiceConnectorGroups []VoiceConnectorGroup `type:"list"`
}

// String returns the string representation
func (s ListVoiceConnectorGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListVoiceConnectorGroupsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VoiceConnectorGroups != nil {
		v := s.VoiceConnectorGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "VoiceConnectorGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListVoiceConnectorGroups = "ListVoiceConnectorGroups"

// ListVoiceConnectorGroupsRequest returns a request value for making API operation for
// Amazon Chime.
//
// Lists the Amazon Chime Voice Connector groups for the administrator's AWS
// account.
//
//    // Example sending a request using ListVoiceConnectorGroupsRequest.
//    req := client.ListVoiceConnectorGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorGroups
func (c *Client) ListVoiceConnectorGroupsRequest(input *ListVoiceConnectorGroupsInput) ListVoiceConnectorGroupsRequest {
	op := &aws.Operation{
		Name:       opListVoiceConnectorGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connector-groups",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVoiceConnectorGroupsInput{}
	}

	req := c.newRequest(op, input, &ListVoiceConnectorGroupsOutput{})

	return ListVoiceConnectorGroupsRequest{Request: req, Input: input, Copy: c.ListVoiceConnectorGroupsRequest}
}

// ListVoiceConnectorGroupsRequest is the request type for the
// ListVoiceConnectorGroups API operation.
type ListVoiceConnectorGroupsRequest struct {
	*aws.Request
	Input *ListVoiceConnectorGroupsInput
	Copy  func(*ListVoiceConnectorGroupsInput) ListVoiceConnectorGroupsRequest
}

// Send marshals and sends the ListVoiceConnectorGroups API request.
func (r ListVoiceConnectorGroupsRequest) Send(ctx context.Context) (*ListVoiceConnectorGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListVoiceConnectorGroupsResponse{
		ListVoiceConnectorGroupsOutput: r.Request.Data.(*ListVoiceConnectorGroupsOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListVoiceConnectorGroupsRequestPaginator returns a paginator for ListVoiceConnectorGroups.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListVoiceConnectorGroupsRequest(input)
//   p := chime.NewListVoiceConnectorGroupsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListVoiceConnectorGroupsPaginator(req ListVoiceConnectorGroupsRequest) ListVoiceConnectorGroupsPaginator {
	return ListVoiceConnectorGroupsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListVoiceConnectorGroupsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListVoiceConnectorGroupsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListVoiceConnectorGroupsPaginator struct {
	aws.Pager
}

func (p *ListVoiceConnectorGroupsPaginator) CurrentPage() *ListVoiceConnectorGroupsOutput {
	return p.Pager.CurrentPage().(*ListVoiceConnectorGroupsOutput)
}

// ListVoiceConnectorGroupsResponse is the response type for the
// ListVoiceConnectorGroups API operation.
type ListVoiceConnectorGroupsResponse struct {
	*ListVoiceConnectorGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListVoiceConnectorGroups request.
func (r *ListVoiceConnectorGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
