// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type RedactConversationMessageInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The conversation ID.
	//
	// ConversationId is a required field
	ConversationId *string `location:"uri" locationName:"conversationId" type:"string" required:"true"`

	// The message ID.
	//
	// MessageId is a required field
	MessageId *string `location:"uri" locationName:"messageId" type:"string" required:"true"`
}

// String returns the string representation
func (s RedactConversationMessageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedactConversationMessageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RedactConversationMessageInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.ConversationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConversationId"))
	}

	if s.MessageId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MessageId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RedactConversationMessageInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConversationId != nil {
		v := *s.ConversationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "conversationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MessageId != nil {
		v := *s.MessageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "messageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type RedactConversationMessageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RedactConversationMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RedactConversationMessageOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opRedactConversationMessage = "RedactConversationMessage"

// RedactConversationMessageRequest returns a request value for making API operation for
// Amazon Chime.
//
// Redacts the specified message from the specified Amazon Chime conversation.
//
//    // Example sending a request using RedactConversationMessageRequest.
//    req := client.RedactConversationMessageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RedactConversationMessage
func (c *Client) RedactConversationMessageRequest(input *RedactConversationMessageInput) RedactConversationMessageRequest {
	op := &aws.Operation{
		Name:       opRedactConversationMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/conversations/{conversationId}/messages/{messageId}?operation=redact",
	}

	if input == nil {
		input = &RedactConversationMessageInput{}
	}

	req := c.newRequest(op, input, &RedactConversationMessageOutput{})

	return RedactConversationMessageRequest{Request: req, Input: input, Copy: c.RedactConversationMessageRequest}
}

// RedactConversationMessageRequest is the request type for the
// RedactConversationMessage API operation.
type RedactConversationMessageRequest struct {
	*aws.Request
	Input *RedactConversationMessageInput
	Copy  func(*RedactConversationMessageInput) RedactConversationMessageRequest
}

// Send marshals and sends the RedactConversationMessage API request.
func (r RedactConversationMessageRequest) Send(ctx context.Context) (*RedactConversationMessageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RedactConversationMessageResponse{
		RedactConversationMessageOutput: r.Request.Data.(*RedactConversationMessageOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RedactConversationMessageResponse is the response type for the
// RedactConversationMessage API operation.
type RedactConversationMessageResponse struct {
	*RedactConversationMessageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RedactConversationMessage request.
func (r *RedactConversationMessageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
