// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ResetPersonalPINInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" type:"string" required:"true"`
}

// String returns the string representation
func (s ResetPersonalPINInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetPersonalPINInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResetPersonalPINInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.UserId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResetPersonalPINInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "userId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ResetPersonalPINOutput struct {
	_ struct{} `type:"structure"`

	// The user details and new personal meeting PIN.
	User *User `type:"structure"`
}

// String returns the string representation
func (s ResetPersonalPINOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResetPersonalPINOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.User != nil {
		v := s.User

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "User", v, metadata)
	}
	return nil
}

const opResetPersonalPIN = "ResetPersonalPIN"

// ResetPersonalPINRequest returns a request value for making API operation for
// Amazon Chime.
//
// Resets the personal meeting PIN for the specified user on an Amazon Chime
// account. Returns the User object with the updated personal meeting PIN.
//
//    // Example sending a request using ResetPersonalPINRequest.
//    req := client.ResetPersonalPINRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ResetPersonalPIN
func (c *Client) ResetPersonalPINRequest(input *ResetPersonalPINInput) ResetPersonalPINRequest {
	op := &aws.Operation{
		Name:       opResetPersonalPIN,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users/{userId}?operation=reset-personal-pin",
	}

	if input == nil {
		input = &ResetPersonalPINInput{}
	}

	req := c.newRequest(op, input, &ResetPersonalPINOutput{})

	return ResetPersonalPINRequest{Request: req, Input: input, Copy: c.ResetPersonalPINRequest}
}

// ResetPersonalPINRequest is the request type for the
// ResetPersonalPIN API operation.
type ResetPersonalPINRequest struct {
	*aws.Request
	Input *ResetPersonalPINInput
	Copy  func(*ResetPersonalPINInput) ResetPersonalPINRequest
}

// Send marshals and sends the ResetPersonalPIN API request.
func (r ResetPersonalPINRequest) Send(ctx context.Context) (*ResetPersonalPINResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ResetPersonalPINResponse{
		ResetPersonalPINOutput: r.Request.Data.(*ResetPersonalPINOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ResetPersonalPINResponse is the response type for the
// ResetPersonalPIN API operation.
type ResetPersonalPINResponse struct {
	*ResetPersonalPINOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ResetPersonalPIN request.
func (r *ResetPersonalPINResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
