// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type RestorePhoneNumberInput struct {
	_ struct{} `type:"structure"`

	// The phone number.
	//
	// PhoneNumberId is a required field
	PhoneNumberId *string `location:"uri" locationName:"phoneNumberId" type:"string" required:"true"`
}

// String returns the string representation
func (s RestorePhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestorePhoneNumberInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RestorePhoneNumberInput"}

	if s.PhoneNumberId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PhoneNumberId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RestorePhoneNumberInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.PhoneNumberId != nil {
		v := *s.PhoneNumberId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "phoneNumberId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type RestorePhoneNumberOutput struct {
	_ struct{} `type:"structure"`

	// The phone number details.
	PhoneNumber *PhoneNumber `type:"structure"`
}

// String returns the string representation
func (s RestorePhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RestorePhoneNumberOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.PhoneNumber != nil {
		v := s.PhoneNumber

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PhoneNumber", v, metadata)
	}
	return nil
}

const opRestorePhoneNumber = "RestorePhoneNumber"

// RestorePhoneNumberRequest returns a request value for making API operation for
// Amazon Chime.
//
// Moves a phone number from the Deletion queue back into the phone number Inventory.
//
//    // Example sending a request using RestorePhoneNumberRequest.
//    req := client.RestorePhoneNumberRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RestorePhoneNumber
func (c *Client) RestorePhoneNumberRequest(input *RestorePhoneNumberInput) RestorePhoneNumberRequest {
	op := &aws.Operation{
		Name:       opRestorePhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-numbers/{phoneNumberId}?operation=restore",
	}

	if input == nil {
		input = &RestorePhoneNumberInput{}
	}

	req := c.newRequest(op, input, &RestorePhoneNumberOutput{})

	return RestorePhoneNumberRequest{Request: req, Input: input, Copy: c.RestorePhoneNumberRequest}
}

// RestorePhoneNumberRequest is the request type for the
// RestorePhoneNumber API operation.
type RestorePhoneNumberRequest struct {
	*aws.Request
	Input *RestorePhoneNumberInput
	Copy  func(*RestorePhoneNumberInput) RestorePhoneNumberRequest
}

// Send marshals and sends the RestorePhoneNumber API request.
func (r RestorePhoneNumberRequest) Send(ctx context.Context) (*RestorePhoneNumberResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RestorePhoneNumberResponse{
		RestorePhoneNumberOutput: r.Request.Data.(*RestorePhoneNumberOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RestorePhoneNumberResponse is the response type for the
// RestorePhoneNumber API operation.
type RestorePhoneNumberResponse struct {
	*RestorePhoneNumberOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RestorePhoneNumber request.
func (r *RestorePhoneNumberResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
