// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type UntagMeetingInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"meetingId" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a required field
	TagKeys []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagMeetingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagMeetingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UntagMeetingInput"}

	if s.MeetingId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MeetingId"))
	}

	if s.TagKeys == nil {
		invalidParams.Add(aws.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UntagMeetingInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TagKeys != nil {
		v := s.TagKeys

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "TagKeys", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.MeetingId != nil {
		v := *s.MeetingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "meetingId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UntagMeetingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagMeetingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UntagMeetingOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUntagMeeting = "UntagMeeting"

// UntagMeetingRequest returns a request value for making API operation for
// Amazon Chime.
//
// Untags the specified tags from the specified Amazon Chime SDK meeting.
//
//    // Example sending a request using UntagMeetingRequest.
//    req := client.UntagMeetingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UntagMeeting
func (c *Client) UntagMeetingRequest(input *UntagMeetingInput) UntagMeetingRequest {
	op := &aws.Operation{
		Name:       opUntagMeeting,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{meetingId}/tags?operation=delete",
	}

	if input == nil {
		input = &UntagMeetingInput{}
	}

	req := c.newRequest(op, input, &UntagMeetingOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return UntagMeetingRequest{Request: req, Input: input, Copy: c.UntagMeetingRequest}
}

// UntagMeetingRequest is the request type for the
// UntagMeeting API operation.
type UntagMeetingRequest struct {
	*aws.Request
	Input *UntagMeetingInput
	Copy  func(*UntagMeetingInput) UntagMeetingRequest
}

// Send marshals and sends the UntagMeeting API request.
func (r UntagMeetingRequest) Send(ctx context.Context) (*UntagMeetingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UntagMeetingResponse{
		UntagMeetingOutput: r.Request.Data.(*UntagMeetingOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UntagMeetingResponse is the response type for the
// UntagMeeting API operation.
type UntagMeetingResponse struct {
	*UntagMeetingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UntagMeeting request.
func (r *UntagMeetingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
