// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateRoomMembershipInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The member ID.
	//
	// MemberId is a required field
	MemberId *string `location:"uri" locationName:"memberId" type:"string" required:"true"`

	// The role of the member.
	Role RoomMembershipRole `type:"string" enum:"true"`

	// The room ID.
	//
	// RoomId is a required field
	RoomId *string `location:"uri" locationName:"roomId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRoomMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRoomMembershipInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateRoomMembershipInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.MemberId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MemberId"))
	}

	if s.RoomId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoomId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRoomMembershipInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if len(s.Role) > 0 {
		v := s.Role

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Role", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MemberId != nil {
		v := *s.MemberId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "memberId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoomId != nil {
		v := *s.RoomId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "roomId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateRoomMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The room membership details.
	RoomMembership *RoomMembership `type:"structure"`
}

// String returns the string representation
func (s UpdateRoomMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateRoomMembershipOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.RoomMembership != nil {
		v := s.RoomMembership

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RoomMembership", v, metadata)
	}
	return nil
}

const opUpdateRoomMembership = "UpdateRoomMembership"

// UpdateRoomMembershipRequest returns a request value for making API operation for
// Amazon Chime.
//
// Updates room membership details, such as the member role, for a room in an
// Amazon Chime Enterprise account. The member role designates whether the member
// is a chat room administrator or a general chat room member. The member role
// can be updated only for user IDs.
//
//    // Example sending a request using UpdateRoomMembershipRequest.
//    req := client.UpdateRoomMembershipRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateRoomMembership
func (c *Client) UpdateRoomMembershipRequest(input *UpdateRoomMembershipInput) UpdateRoomMembershipRequest {
	op := &aws.Operation{
		Name:       opUpdateRoomMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}/memberships/{memberId}",
	}

	if input == nil {
		input = &UpdateRoomMembershipInput{}
	}

	req := c.newRequest(op, input, &UpdateRoomMembershipOutput{})

	return UpdateRoomMembershipRequest{Request: req, Input: input, Copy: c.UpdateRoomMembershipRequest}
}

// UpdateRoomMembershipRequest is the request type for the
// UpdateRoomMembership API operation.
type UpdateRoomMembershipRequest struct {
	*aws.Request
	Input *UpdateRoomMembershipInput
	Copy  func(*UpdateRoomMembershipInput) UpdateRoomMembershipRequest
}

// Send marshals and sends the UpdateRoomMembership API request.
func (r UpdateRoomMembershipRequest) Send(ctx context.Context) (*UpdateRoomMembershipResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRoomMembershipResponse{
		UpdateRoomMembershipOutput: r.Request.Data.(*UpdateRoomMembershipOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRoomMembershipResponse is the response type for the
// UpdateRoomMembership API operation.
type UpdateRoomMembershipResponse struct {
	*UpdateRoomMembershipOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRoomMembership request.
func (r *UpdateRoomMembershipResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
