// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateVoiceConnectorGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Chime Voice Connector group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Chime Voice Connector group ID.
	//
	// VoiceConnectorGroupId is a required field
	VoiceConnectorGroupId *string `location:"uri" locationName:"voiceConnectorGroupId" type:"string" required:"true"`

	// The VoiceConnectorItems to associate with the group.
	//
	// VoiceConnectorItems is a required field
	VoiceConnectorItems []VoiceConnectorItem `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateVoiceConnectorGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVoiceConnectorGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateVoiceConnectorGroupInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.VoiceConnectorGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VoiceConnectorGroupId"))
	}

	if s.VoiceConnectorItems == nil {
		invalidParams.Add(aws.NewErrParamRequired("VoiceConnectorItems"))
	}
	if s.VoiceConnectorItems != nil {
		for i, v := range s.VoiceConnectorItems {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VoiceConnectorItems", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateVoiceConnectorGroupInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VoiceConnectorItems != nil {
		v := s.VoiceConnectorItems

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "VoiceConnectorItems", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.VoiceConnectorGroupId != nil {
		v := *s.VoiceConnectorGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "voiceConnectorGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateVoiceConnectorGroupOutput struct {
	_ struct{} `type:"structure"`

	// The updated Amazon Chime Voice Connector group details.
	VoiceConnectorGroup *VoiceConnectorGroup `type:"structure"`
}

// String returns the string representation
func (s UpdateVoiceConnectorGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateVoiceConnectorGroupOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.VoiceConnectorGroup != nil {
		v := s.VoiceConnectorGroup

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VoiceConnectorGroup", v, metadata)
	}
	return nil
}

const opUpdateVoiceConnectorGroup = "UpdateVoiceConnectorGroup"

// UpdateVoiceConnectorGroupRequest returns a request value for making API operation for
// Amazon Chime.
//
// Updates details for the specified Amazon Chime Voice Connector group, such
// as the name and Amazon Chime Voice Connector priority ranking.
//
//    // Example sending a request using UpdateVoiceConnectorGroupRequest.
//    req := client.UpdateVoiceConnectorGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateVoiceConnectorGroup
func (c *Client) UpdateVoiceConnectorGroupRequest(input *UpdateVoiceConnectorGroupInput) UpdateVoiceConnectorGroupRequest {
	op := &aws.Operation{
		Name:       opUpdateVoiceConnectorGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}",
	}

	if input == nil {
		input = &UpdateVoiceConnectorGroupInput{}
	}

	req := c.newRequest(op, input, &UpdateVoiceConnectorGroupOutput{})

	return UpdateVoiceConnectorGroupRequest{Request: req, Input: input, Copy: c.UpdateVoiceConnectorGroupRequest}
}

// UpdateVoiceConnectorGroupRequest is the request type for the
// UpdateVoiceConnectorGroup API operation.
type UpdateVoiceConnectorGroupRequest struct {
	*aws.Request
	Input *UpdateVoiceConnectorGroupInput
	Copy  func(*UpdateVoiceConnectorGroupInput) UpdateVoiceConnectorGroupRequest
}

// Send marshals and sends the UpdateVoiceConnectorGroup API request.
func (r UpdateVoiceConnectorGroupRequest) Send(ctx context.Context) (*UpdateVoiceConnectorGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateVoiceConnectorGroupResponse{
		UpdateVoiceConnectorGroupOutput: r.Request.Data.(*UpdateVoiceConnectorGroupOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateVoiceConnectorGroupResponse is the response type for the
// UpdateVoiceConnectorGroup API operation.
type UpdateVoiceConnectorGroupResponse struct {
	*UpdateVoiceConnectorGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateVoiceConnectorGroup request.
func (r *UpdateVoiceConnectorGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
