// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloud9

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment to delete.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteEnvironmentInput"}

	if s.EnvironmentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EnvironmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteEnvironment = "DeleteEnvironment"

// DeleteEnvironmentRequest returns a request value for making API operation for
// AWS Cloud9.
//
// Deletes an AWS Cloud9 development environment. If an Amazon EC2 instance
// is connected to the environment, also terminates the instance.
//
//    // Example sending a request using DeleteEnvironmentRequest.
//    req := client.DeleteEnvironmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DeleteEnvironment
func (c *Client) DeleteEnvironmentRequest(input *DeleteEnvironmentInput) DeleteEnvironmentRequest {
	op := &aws.Operation{
		Name:       opDeleteEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEnvironmentInput{}
	}

	req := c.newRequest(op, input, &DeleteEnvironmentOutput{})

	return DeleteEnvironmentRequest{Request: req, Input: input, Copy: c.DeleteEnvironmentRequest}
}

// DeleteEnvironmentRequest is the request type for the
// DeleteEnvironment API operation.
type DeleteEnvironmentRequest struct {
	*aws.Request
	Input *DeleteEnvironmentInput
	Copy  func(*DeleteEnvironmentInput) DeleteEnvironmentRequest
}

// Send marshals and sends the DeleteEnvironment API request.
func (r DeleteEnvironmentRequest) Send(ctx context.Context) (*DeleteEnvironmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteEnvironmentResponse{
		DeleteEnvironmentOutput: r.Request.Data.(*DeleteEnvironmentOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteEnvironmentResponse is the response type for the
// DeleteEnvironment API operation.
type DeleteEnvironmentResponse struct {
	*DeleteEnvironmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteEnvironment request.
func (r *DeleteEnvironmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
