// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloud9

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListEnvironmentsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of environments to get identifiers for.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// During a previous call, if there are more than 25 items in the list, only
	// the first 25 items are returned, along with a unique string called a next
	// token. To get the next batch of items in the list, call this operation again,
	// adding the next token to the call. To get all of the items in the list, keep
	// calling this operation with each subsequent next token that is returned,
	// until no more next tokens are returned.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListEnvironmentsInput) String() string {
	return awsutil.Prettify(s)
}

type ListEnvironmentsOutput struct {
	_ struct{} `type:"structure"`

	// The list of environment identifiers.
	EnvironmentIds []string `locationName:"environmentIds" type:"list"`

	// If there are more than 25 items in the list, only the first 25 items are
	// returned, along with a unique string called a next token. To get the next
	// batch of items in the list, call this operation again, adding the next token
	// to the call.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListEnvironmentsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListEnvironments = "ListEnvironments"

// ListEnvironmentsRequest returns a request value for making API operation for
// AWS Cloud9.
//
// Gets a list of AWS Cloud9 development environment identifiers.
//
//    // Example sending a request using ListEnvironmentsRequest.
//    req := client.ListEnvironmentsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/ListEnvironments
func (c *Client) ListEnvironmentsRequest(input *ListEnvironmentsInput) ListEnvironmentsRequest {
	op := &aws.Operation{
		Name:       opListEnvironments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentsInput{}
	}

	req := c.newRequest(op, input, &ListEnvironmentsOutput{})

	return ListEnvironmentsRequest{Request: req, Input: input, Copy: c.ListEnvironmentsRequest}
}

// ListEnvironmentsRequest is the request type for the
// ListEnvironments API operation.
type ListEnvironmentsRequest struct {
	*aws.Request
	Input *ListEnvironmentsInput
	Copy  func(*ListEnvironmentsInput) ListEnvironmentsRequest
}

// Send marshals and sends the ListEnvironments API request.
func (r ListEnvironmentsRequest) Send(ctx context.Context) (*ListEnvironmentsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListEnvironmentsResponse{
		ListEnvironmentsOutput: r.Request.Data.(*ListEnvironmentsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListEnvironmentsRequestPaginator returns a paginator for ListEnvironments.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListEnvironmentsRequest(input)
//   p := cloud9.NewListEnvironmentsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListEnvironmentsPaginator(req ListEnvironmentsRequest) ListEnvironmentsPaginator {
	return ListEnvironmentsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListEnvironmentsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListEnvironmentsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListEnvironmentsPaginator struct {
	aws.Pager
}

func (p *ListEnvironmentsPaginator) CurrentPage() *ListEnvironmentsOutput {
	return p.Pager.CurrentPage().(*ListEnvironmentsOutput)
}

// ListEnvironmentsResponse is the response type for the
// ListEnvironments API operation.
type ListEnvironmentsResponse struct {
	*ListEnvironmentsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListEnvironments request.
func (r *ListEnvironmentsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
