// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddirectory

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DetachObjectInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that is associated with the Directory where
	// objects reside. For more information, see arns.
	//
	// DirectoryArn is a required field
	DirectoryArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`

	// The link name associated with the object that needs to be detached.
	//
	// LinkName is a required field
	LinkName *string `min:"1" type:"string" required:"true"`

	// The parent reference from which the object with the specified link name is
	// detached.
	//
	// ParentReference is a required field
	ParentReference *ObjectReference `type:"structure" required:"true"`
}

// String returns the string representation
func (s DetachObjectInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachObjectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetachObjectInput"}

	if s.DirectoryArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryArn"))
	}

	if s.LinkName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LinkName"))
	}
	if s.LinkName != nil && len(*s.LinkName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LinkName", 1))
	}

	if s.ParentReference == nil {
		invalidParams.Add(aws.NewErrParamRequired("ParentReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetachObjectInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.LinkName != nil {
		v := *s.LinkName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LinkName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParentReference != nil {
		v := s.ParentReference

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ParentReference", v, metadata)
	}
	if s.DirectoryArn != nil {
		v := *s.DirectoryArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-data-partition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DetachObjectOutput struct {
	_ struct{} `type:"structure"`

	// The ObjectIdentifier that was detached from the object.
	DetachedObjectIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DetachObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetachObjectOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DetachedObjectIdentifier != nil {
		v := *s.DetachedObjectIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DetachedObjectIdentifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDetachObject = "DetachObject"

// DetachObjectRequest returns a request value for making API operation for
// Amazon CloudDirectory.
//
// Detaches a given object from the parent object. The object that is to be
// detached from the parent is specified by the link name.
//
//    // Example sending a request using DetachObjectRequest.
//    req := client.DetachObjectRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/DetachObject
func (c *Client) DetachObjectRequest(input *DetachObjectInput) DetachObjectRequest {
	op := &aws.Operation{
		Name:       opDetachObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/object/detach",
	}

	if input == nil {
		input = &DetachObjectInput{}
	}

	req := c.newRequest(op, input, &DetachObjectOutput{})

	return DetachObjectRequest{Request: req, Input: input, Copy: c.DetachObjectRequest}
}

// DetachObjectRequest is the request type for the
// DetachObject API operation.
type DetachObjectRequest struct {
	*aws.Request
	Input *DetachObjectInput
	Copy  func(*DetachObjectInput) DetachObjectRequest
}

// Send marshals and sends the DetachObject API request.
func (r DetachObjectRequest) Send(ctx context.Context) (*DetachObjectResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DetachObjectResponse{
		DetachObjectOutput: r.Request.Data.(*DetachObjectOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DetachObjectResponse is the response type for the
// DetachObject API operation.
type DetachObjectResponse struct {
	*DetachObjectOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DetachObject request.
func (r *DetachObjectResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
