// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddirectory

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetFacetInput struct {
	_ struct{} `type:"structure"`

	// The name of the facet to retrieve.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that is associated with the Facet. For more
	// information, see arns.
	//
	// SchemaArn is a required field
	SchemaArn *string `location:"header" locationName:"x-amz-data-partition" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFacetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFacetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetFacetInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.SchemaArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetFacetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SchemaArn != nil {
		v := *s.SchemaArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-data-partition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetFacetOutput struct {
	_ struct{} `type:"structure"`

	// The Facet structure that is associated with the facet.
	Facet *Facet `type:"structure"`
}

// String returns the string representation
func (s GetFacetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetFacetOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Facet != nil {
		v := s.Facet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Facet", v, metadata)
	}
	return nil
}

const opGetFacet = "GetFacet"

// GetFacetRequest returns a request value for making API operation for
// Amazon CloudDirectory.
//
// Gets details of the Facet, such as facet name, attributes, Rules, or ObjectType.
// You can call this on all kinds of schema facets -- published, development,
// or applied.
//
//    // Example sending a request using GetFacetRequest.
//    req := client.GetFacetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/GetFacet
func (c *Client) GetFacetRequest(input *GetFacetInput) GetFacetRequest {
	op := &aws.Operation{
		Name:       opGetFacet,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/facet",
	}

	if input == nil {
		input = &GetFacetInput{}
	}

	req := c.newRequest(op, input, &GetFacetOutput{})

	return GetFacetRequest{Request: req, Input: input, Copy: c.GetFacetRequest}
}

// GetFacetRequest is the request type for the
// GetFacet API operation.
type GetFacetRequest struct {
	*aws.Request
	Input *GetFacetInput
	Copy  func(*GetFacetInput) GetFacetRequest
}

// Send marshals and sends the GetFacet API request.
func (r GetFacetRequest) Send(ctx context.Context) (*GetFacetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetFacetResponse{
		GetFacetOutput: r.Request.Data.(*GetFacetOutput),
		response:       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetFacetResponse is the response type for the
// GetFacet API operation.
type GetFacetResponse struct {
	*GetFacetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetFacet request.
func (r *GetFacetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
