// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeStackResourceDriftsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string that identifies the next page of stack resource drift results.
	NextToken *string `min:"1" type:"string"`

	// The name of the stack for which you want drift information.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// The resource drift status values to use as filters for the resource drift
	// results returned.
	//
	//    * DELETED: The resource differs from its expected template configuration
	//    in that the resource has been deleted.
	//
	//    * MODIFIED: One or more resource properties differ from their expected
	//    template values.
	//
	//    * IN_SYNC: The resources's actual configuration matches its expected template
	//    configuration.
	//
	//    * NOT_CHECKED: AWS CloudFormation does not currently return this value.
	StackResourceDriftStatusFilters []StackResourceDriftStatus `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeStackResourceDriftsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackResourceDriftsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeStackResourceDriftsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackName", 1))
	}
	if s.StackResourceDriftStatusFilters != nil && len(s.StackResourceDriftStatusFilters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackResourceDriftStatusFilters", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeStackResourceDriftsOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all of the remaining results, NextToken is
	// set to a token. To retrieve the next set of results, call DescribeStackResourceDrifts
	// again and assign that token to the request object's NextToken parameter.
	// If the request returns all results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// Drift information for the resources that have been checked for drift in the
	// specified stack. This includes actual and expected configuration values for
	// resources where AWS CloudFormation detects drift.
	//
	// For a given stack, there will be one StackResourceDrift for each stack resource
	// that has been checked for drift. Resources that have not yet been checked
	// for drift are not included. Resources that do not currently support drift
	// detection are not checked, and so not included. For a list of resources that
	// support drift detection, see Resources that Support Drift Detection (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
	//
	// StackResourceDrifts is a required field
	StackResourceDrifts []StackResourceDrift `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeStackResourceDriftsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeStackResourceDrifts = "DescribeStackResourceDrifts"

// DescribeStackResourceDriftsRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns drift information for the resources that have been checked for drift
// in the specified stack. This includes actual and expected configuration values
// for resources where AWS CloudFormation detects configuration drift.
//
// For a given stack, there will be one StackResourceDrift for each stack resource
// that has been checked for drift. Resources that have not yet been checked
// for drift are not included. Resources that do not currently support drift
// detection are not checked, and so not included. For a list of resources that
// support drift detection, see Resources that Support Drift Detection (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift-resource-list.html).
//
// Use DetectStackResourceDrift to detect drift on individual resources, or
// DetectStackDrift to detect drift on all supported resources for a given stack.
//
//    // Example sending a request using DescribeStackResourceDriftsRequest.
//    req := client.DescribeStackResourceDriftsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/DescribeStackResourceDrifts
func (c *Client) DescribeStackResourceDriftsRequest(input *DescribeStackResourceDriftsInput) DescribeStackResourceDriftsRequest {
	op := &aws.Operation{
		Name:       opDescribeStackResourceDrifts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStackResourceDriftsInput{}
	}

	req := c.newRequest(op, input, &DescribeStackResourceDriftsOutput{})

	return DescribeStackResourceDriftsRequest{Request: req, Input: input, Copy: c.DescribeStackResourceDriftsRequest}
}

// DescribeStackResourceDriftsRequest is the request type for the
// DescribeStackResourceDrifts API operation.
type DescribeStackResourceDriftsRequest struct {
	*aws.Request
	Input *DescribeStackResourceDriftsInput
	Copy  func(*DescribeStackResourceDriftsInput) DescribeStackResourceDriftsRequest
}

// Send marshals and sends the DescribeStackResourceDrifts API request.
func (r DescribeStackResourceDriftsRequest) Send(ctx context.Context) (*DescribeStackResourceDriftsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeStackResourceDriftsResponse{
		DescribeStackResourceDriftsOutput: r.Request.Data.(*DescribeStackResourceDriftsOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeStackResourceDriftsRequestPaginator returns a paginator for DescribeStackResourceDrifts.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeStackResourceDriftsRequest(input)
//   p := cloudformation.NewDescribeStackResourceDriftsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeStackResourceDriftsPaginator(req DescribeStackResourceDriftsRequest) DescribeStackResourceDriftsPaginator {
	return DescribeStackResourceDriftsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeStackResourceDriftsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeStackResourceDriftsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeStackResourceDriftsPaginator struct {
	aws.Pager
}

func (p *DescribeStackResourceDriftsPaginator) CurrentPage() *DescribeStackResourceDriftsOutput {
	return p.Pager.CurrentPage().(*DescribeStackResourceDriftsOutput)
}

// DescribeStackResourceDriftsResponse is the response type for the
// DescribeStackResourceDrifts API operation.
type DescribeStackResourceDriftsResponse struct {
	*DescribeStackResourceDriftsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeStackResourceDrifts request.
func (r *DescribeStackResourceDriftsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
