// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// The input for the SignalResource action.
type SignalResourceInput struct {
	_ struct{} `type:"structure"`

	// The logical ID of the resource that you want to signal. The logical ID is
	// the name of the resource that given in the template.
	//
	// LogicalResourceId is a required field
	LogicalResourceId *string `type:"string" required:"true"`

	// The stack name or unique stack ID that includes the resource that you want
	// to signal.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`

	// The status of the signal, which is either success or failure. A failure signal
	// causes AWS CloudFormation to immediately fail the stack creation or update.
	//
	// Status is a required field
	Status ResourceSignalStatus `type:"string" required:"true" enum:"true"`

	// A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling
	// groups, specify the instance ID that you are signaling as the unique ID.
	// If you send multiple signals to a single resource (such as signaling a wait
	// condition), each signal requires a different unique ID.
	//
	// UniqueId is a required field
	UniqueId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignalResourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignalResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SignalResourceInput"}

	if s.LogicalResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogicalResourceId"))
	}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackName", 1))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if s.UniqueId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UniqueId"))
	}
	if s.UniqueId != nil && len(*s.UniqueId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UniqueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SignalResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SignalResourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opSignalResource = "SignalResource"

// SignalResourceRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Sends a signal to the specified resource with a success or failure status.
// You can use the SignalResource API in conjunction with a creation policy
// or update policy. AWS CloudFormation doesn't proceed with a stack creation
// or update until resources receive the required number of signals or the timeout
// period is exceeded. The SignalResource API is useful in cases where you want
// to send signals from anywhere other than an Amazon EC2 instance.
//
//    // Example sending a request using SignalResourceRequest.
//    req := client.SignalResourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/SignalResource
func (c *Client) SignalResourceRequest(input *SignalResourceInput) SignalResourceRequest {
	op := &aws.Operation{
		Name:       opSignalResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SignalResourceInput{}
	}

	req := c.newRequest(op, input, &SignalResourceOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return SignalResourceRequest{Request: req, Input: input, Copy: c.SignalResourceRequest}
}

// SignalResourceRequest is the request type for the
// SignalResource API operation.
type SignalResourceRequest struct {
	*aws.Request
	Input *SignalResourceInput
	Copy  func(*SignalResourceInput) SignalResourceRequest
}

// Send marshals and sends the SignalResource API request.
func (r SignalResourceRequest) Send(ctx context.Context) (*SignalResourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SignalResourceResponse{
		SignalResourceOutput: r.Request.Data.(*SignalResourceOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SignalResourceResponse is the response type for the
// SignalResource API operation.
type SignalResourceResponse struct {
	*SignalResourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SignalResource request.
func (r *SignalResourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
