// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The request to create a new streaming distribution with tags.
type CreateStreamingDistributionWithTagsInput struct {
	_ struct{} `type:"structure" payload:"StreamingDistributionConfigWithTags"`

	// The streaming distribution's configuration information.
	//
	// StreamingDistributionConfigWithTags is a required field
	StreamingDistributionConfigWithTags *StreamingDistributionConfigWithTags `locationName:"StreamingDistributionConfigWithTags" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2020-05-31/"`
}

// String returns the string representation
func (s CreateStreamingDistributionWithTagsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamingDistributionWithTagsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateStreamingDistributionWithTagsInput"}

	if s.StreamingDistributionConfigWithTags == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamingDistributionConfigWithTags"))
	}
	if s.StreamingDistributionConfigWithTags != nil {
		if err := s.StreamingDistributionConfigWithTags.Validate(); err != nil {
			invalidParams.AddNested("StreamingDistributionConfigWithTags", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateStreamingDistributionWithTagsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.StreamingDistributionConfigWithTags != nil {
		v := s.StreamingDistributionConfigWithTags

		metadata := protocol.Metadata{XMLNamespaceURI: "http://cloudfront.amazonaws.com/doc/2020-05-31/"}
		e.SetFields(protocol.PayloadTarget, "StreamingDistributionConfigWithTags", v, metadata)
	}
	return nil
}

// The returned result of the corresponding request.
type CreateStreamingDistributionWithTagsOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistribution"`

	// The current version of the distribution created.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the new streaming distribution resource just created.
	Location *string `location:"header" locationName:"Location" type:"string"`

	// The streaming distribution's information.
	StreamingDistribution *StreamingDistribution `type:"structure"`
}

// String returns the string representation
func (s CreateStreamingDistributionWithTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateStreamingDistributionWithTagsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.Location != nil {
		v := *s.Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Location", protocol.StringValue(v), metadata)
	}
	if s.StreamingDistribution != nil {
		v := s.StreamingDistribution

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "StreamingDistribution", v, metadata)
	}
	return nil
}

const opCreateStreamingDistributionWithTags = "CreateStreamingDistributionWithTags2020_05_31"

// CreateStreamingDistributionWithTagsRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Create a new streaming distribution with tags.
//
//    // Example sending a request using CreateStreamingDistributionWithTagsRequest.
//    req := client.CreateStreamingDistributionWithTagsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateStreamingDistributionWithTags
func (c *Client) CreateStreamingDistributionWithTagsRequest(input *CreateStreamingDistributionWithTagsInput) CreateStreamingDistributionWithTagsRequest {
	op := &aws.Operation{
		Name:       opCreateStreamingDistributionWithTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-05-31/streaming-distribution?WithTags",
	}

	if input == nil {
		input = &CreateStreamingDistributionWithTagsInput{}
	}

	req := c.newRequest(op, input, &CreateStreamingDistributionWithTagsOutput{})

	return CreateStreamingDistributionWithTagsRequest{Request: req, Input: input, Copy: c.CreateStreamingDistributionWithTagsRequest}
}

// CreateStreamingDistributionWithTagsRequest is the request type for the
// CreateStreamingDistributionWithTags API operation.
type CreateStreamingDistributionWithTagsRequest struct {
	*aws.Request
	Input *CreateStreamingDistributionWithTagsInput
	Copy  func(*CreateStreamingDistributionWithTagsInput) CreateStreamingDistributionWithTagsRequest
}

// Send marshals and sends the CreateStreamingDistributionWithTags API request.
func (r CreateStreamingDistributionWithTagsRequest) Send(ctx context.Context) (*CreateStreamingDistributionWithTagsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateStreamingDistributionWithTagsResponse{
		CreateStreamingDistributionWithTagsOutput: r.Request.Data.(*CreateStreamingDistributionWithTagsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateStreamingDistributionWithTagsResponse is the response type for the
// CreateStreamingDistributionWithTags API operation.
type CreateStreamingDistributionWithTagsResponse struct {
	*CreateStreamingDistributionWithTagsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateStreamingDistributionWithTags request.
func (r *CreateStreamingDistributionWithTagsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
