// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

type DeleteCachePolicyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the cache policy that you are deleting. To get
	// the identifier, you can use ListCachePolicies.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The version of the cache policy that you are deleting. The version is the
	// cache policy’s ETag value, which you can get using ListCachePolicies, GetCachePolicy,
	// or GetCachePolicyConfig.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteCachePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCachePolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteCachePolicyInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteCachePolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.IfMatch != nil {
		v := *s.IfMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-Match", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

type DeleteCachePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCachePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteCachePolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteCachePolicy = "DeleteCachePolicy2020_05_31"

// DeleteCachePolicyRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Deletes a cache policy.
//
// You cannot delete a cache policy if it’s attached to a cache behavior.
// First update your distributions to remove the cache policy from all cache
// behaviors, then delete the cache policy.
//
// To delete a cache policy, you must provide the policy’s identifier and
// version. To get these values, you can use ListCachePolicies or GetCachePolicy.
//
//    // Example sending a request using DeleteCachePolicyRequest.
//    req := client.DeleteCachePolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteCachePolicy
func (c *Client) DeleteCachePolicyRequest(input *DeleteCachePolicyInput) DeleteCachePolicyRequest {
	op := &aws.Operation{
		Name:       opDeleteCachePolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-05-31/cache-policy/{Id}",
	}

	if input == nil {
		input = &DeleteCachePolicyInput{}
	}

	req := c.newRequest(op, input, &DeleteCachePolicyOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteCachePolicyRequest{Request: req, Input: input, Copy: c.DeleteCachePolicyRequest}
}

// DeleteCachePolicyRequest is the request type for the
// DeleteCachePolicy API operation.
type DeleteCachePolicyRequest struct {
	*aws.Request
	Input *DeleteCachePolicyInput
	Copy  func(*DeleteCachePolicyInput) DeleteCachePolicyRequest
}

// Send marshals and sends the DeleteCachePolicy API request.
func (r DeleteCachePolicyRequest) Send(ctx context.Context) (*DeleteCachePolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteCachePolicyResponse{
		DeleteCachePolicyOutput: r.Request.Data.(*DeleteCachePolicyOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteCachePolicyResponse is the response type for the
// DeleteCachePolicy API operation.
type DeleteCachePolicyResponse struct {
	*DeleteCachePolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteCachePolicy request.
func (r *DeleteCachePolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
