// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetCachePolicyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the cache policy. If the cache policy is attached
	// to a distribution’s cache behavior, you can get the policy’s identifier
	// using ListDistributions or GetDistribution. If the cache policy is not attached
	// to a cache behavior, you can get the identifier using ListCachePolicies.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCachePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCachePolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCachePolicyInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCachePolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

type GetCachePolicyOutput struct {
	_ struct{} `type:"structure" payload:"CachePolicy"`

	// The cache policy.
	CachePolicy *CachePolicy `type:"structure"`

	// The current version of the cache policy.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetCachePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCachePolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.CachePolicy != nil {
		v := s.CachePolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "CachePolicy", v, metadata)
	}
	return nil
}

const opGetCachePolicy = "GetCachePolicy2020_05_31"

// GetCachePolicyRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Gets a cache policy, including the following metadata:
//
//    * The policy’s identifier.
//
//    * The date and time when the policy was last modified.
//
// To get a cache policy, you must provide the policy’s identifier. If the
// cache policy is attached to a distribution’s cache behavior, you can get
// the policy’s identifier using ListDistributions or GetDistribution. If
// the cache policy is not attached to a cache behavior, you can get the identifier
// using ListCachePolicies.
//
//    // Example sending a request using GetCachePolicyRequest.
//    req := client.GetCachePolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicy
func (c *Client) GetCachePolicyRequest(input *GetCachePolicyInput) GetCachePolicyRequest {
	op := &aws.Operation{
		Name:       opGetCachePolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/cache-policy/{Id}",
	}

	if input == nil {
		input = &GetCachePolicyInput{}
	}

	req := c.newRequest(op, input, &GetCachePolicyOutput{})

	return GetCachePolicyRequest{Request: req, Input: input, Copy: c.GetCachePolicyRequest}
}

// GetCachePolicyRequest is the request type for the
// GetCachePolicy API operation.
type GetCachePolicyRequest struct {
	*aws.Request
	Input *GetCachePolicyInput
	Copy  func(*GetCachePolicyInput) GetCachePolicyRequest
}

// Send marshals and sends the GetCachePolicy API request.
func (r GetCachePolicyRequest) Send(ctx context.Context) (*GetCachePolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCachePolicyResponse{
		GetCachePolicyOutput: r.Request.Data.(*GetCachePolicyOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCachePolicyResponse is the response type for the
// GetCachePolicy API operation.
type GetCachePolicyResponse struct {
	*GetCachePolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCachePolicy request.
func (r *GetCachePolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
