// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetCachePolicyConfigInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the cache policy. If the cache policy is attached
	// to a distribution’s cache behavior, you can get the policy’s identifier
	// using ListDistributions or GetDistribution. If the cache policy is not attached
	// to a cache behavior, you can get the identifier using ListCachePolicies.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCachePolicyConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCachePolicyConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCachePolicyConfigInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCachePolicyConfigInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

type GetCachePolicyConfigOutput struct {
	_ struct{} `type:"structure" payload:"CachePolicyConfig"`

	// The cache policy configuration.
	CachePolicyConfig *CachePolicyConfig `type:"structure"`

	// The current version of the cache policy.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetCachePolicyConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCachePolicyConfigOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.CachePolicyConfig != nil {
		v := s.CachePolicyConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "CachePolicyConfig", v, metadata)
	}
	return nil
}

const opGetCachePolicyConfig = "GetCachePolicyConfig2020_05_31"

// GetCachePolicyConfigRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Gets a cache policy configuration.
//
// To get a cache policy configuration, you must provide the policy’s identifier.
// If the cache policy is attached to a distribution’s cache behavior, you
// can get the policy’s identifier using ListDistributions or GetDistribution.
// If the cache policy is not attached to a cache behavior, you can get the
// identifier using ListCachePolicies.
//
//    // Example sending a request using GetCachePolicyConfigRequest.
//    req := client.GetCachePolicyConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicyConfig
func (c *Client) GetCachePolicyConfigRequest(input *GetCachePolicyConfigInput) GetCachePolicyConfigRequest {
	op := &aws.Operation{
		Name:       opGetCachePolicyConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/cache-policy/{Id}/config",
	}

	if input == nil {
		input = &GetCachePolicyConfigInput{}
	}

	req := c.newRequest(op, input, &GetCachePolicyConfigOutput{})

	return GetCachePolicyConfigRequest{Request: req, Input: input, Copy: c.GetCachePolicyConfigRequest}
}

// GetCachePolicyConfigRequest is the request type for the
// GetCachePolicyConfig API operation.
type GetCachePolicyConfigRequest struct {
	*aws.Request
	Input *GetCachePolicyConfigInput
	Copy  func(*GetCachePolicyConfigInput) GetCachePolicyConfigRequest
}

// Send marshals and sends the GetCachePolicyConfig API request.
func (r GetCachePolicyConfigRequest) Send(ctx context.Context) (*GetCachePolicyConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCachePolicyConfigResponse{
		GetCachePolicyConfigOutput: r.Request.Data.(*GetCachePolicyConfigOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCachePolicyConfigResponse is the response type for the
// GetCachePolicyConfig API operation.
type GetCachePolicyConfigResponse struct {
	*GetCachePolicyConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCachePolicyConfig request.
func (r *GetCachePolicyConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
