// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The origin access identity's configuration information. For more information,
// see CloudFrontOriginAccessIdentityConfig (https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CloudFrontOriginAccessIdentityConfig.html).
type GetCloudFrontOriginAccessIdentityConfigInput struct {
	_ struct{} `type:"structure"`

	// The identity's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCloudFrontOriginAccessIdentityConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCloudFrontOriginAccessIdentityConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCloudFrontOriginAccessIdentityConfigInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCloudFrontOriginAccessIdentityConfigInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

// The returned result of the corresponding request.
type GetCloudFrontOriginAccessIdentityConfigOutput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentityConfig"`

	// The origin access identity's configuration information.
	CloudFrontOriginAccessIdentityConfig *CloudFrontOriginAccessIdentityConfig `type:"structure"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetCloudFrontOriginAccessIdentityConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCloudFrontOriginAccessIdentityConfigOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.CloudFrontOriginAccessIdentityConfig != nil {
		v := s.CloudFrontOriginAccessIdentityConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "CloudFrontOriginAccessIdentityConfig", v, metadata)
	}
	return nil
}

const opGetCloudFrontOriginAccessIdentityConfig = "GetCloudFrontOriginAccessIdentityConfig2020_05_31"

// GetCloudFrontOriginAccessIdentityConfigRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Get the configuration information about an origin access identity.
//
//    // Example sending a request using GetCloudFrontOriginAccessIdentityConfigRequest.
//    req := client.GetCloudFrontOriginAccessIdentityConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCloudFrontOriginAccessIdentityConfig
func (c *Client) GetCloudFrontOriginAccessIdentityConfigRequest(input *GetCloudFrontOriginAccessIdentityConfigInput) GetCloudFrontOriginAccessIdentityConfigRequest {
	op := &aws.Operation{
		Name:       opGetCloudFrontOriginAccessIdentityConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/origin-access-identity/cloudfront/{Id}/config",
	}

	if input == nil {
		input = &GetCloudFrontOriginAccessIdentityConfigInput{}
	}

	req := c.newRequest(op, input, &GetCloudFrontOriginAccessIdentityConfigOutput{})

	return GetCloudFrontOriginAccessIdentityConfigRequest{Request: req, Input: input, Copy: c.GetCloudFrontOriginAccessIdentityConfigRequest}
}

// GetCloudFrontOriginAccessIdentityConfigRequest is the request type for the
// GetCloudFrontOriginAccessIdentityConfig API operation.
type GetCloudFrontOriginAccessIdentityConfigRequest struct {
	*aws.Request
	Input *GetCloudFrontOriginAccessIdentityConfigInput
	Copy  func(*GetCloudFrontOriginAccessIdentityConfigInput) GetCloudFrontOriginAccessIdentityConfigRequest
}

// Send marshals and sends the GetCloudFrontOriginAccessIdentityConfig API request.
func (r GetCloudFrontOriginAccessIdentityConfigRequest) Send(ctx context.Context) (*GetCloudFrontOriginAccessIdentityConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCloudFrontOriginAccessIdentityConfigResponse{
		GetCloudFrontOriginAccessIdentityConfigOutput: r.Request.Data.(*GetCloudFrontOriginAccessIdentityConfigOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCloudFrontOriginAccessIdentityConfigResponse is the response type for the
// GetCloudFrontOriginAccessIdentityConfig API operation.
type GetCloudFrontOriginAccessIdentityConfigResponse struct {
	*GetCloudFrontOriginAccessIdentityConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCloudFrontOriginAccessIdentityConfig request.
func (r *GetCloudFrontOriginAccessIdentityConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
