// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetOriginRequestPolicyConfigInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the origin request policy. If the origin request
	// policy is attached to a distribution’s cache behavior, you can get the
	// policy’s identifier using ListDistributions or GetDistribution. If the
	// origin request policy is not attached to a cache behavior, you can get the
	// identifier using ListOriginRequestPolicies.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOriginRequestPolicyConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOriginRequestPolicyConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetOriginRequestPolicyConfigInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetOriginRequestPolicyConfigInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

type GetOriginRequestPolicyConfigOutput struct {
	_ struct{} `type:"structure" payload:"OriginRequestPolicyConfig"`

	// The current version of the origin request policy.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The origin request policy configuration.
	OriginRequestPolicyConfig *OriginRequestPolicyConfig `type:"structure"`
}

// String returns the string representation
func (s GetOriginRequestPolicyConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetOriginRequestPolicyConfigOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.OriginRequestPolicyConfig != nil {
		v := s.OriginRequestPolicyConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "OriginRequestPolicyConfig", v, metadata)
	}
	return nil
}

const opGetOriginRequestPolicyConfig = "GetOriginRequestPolicyConfig2020_05_31"

// GetOriginRequestPolicyConfigRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Gets an origin request policy configuration.
//
// To get an origin request policy configuration, you must provide the policy’s
// identifier. If the origin request policy is attached to a distribution’s
// cache behavior, you can get the policy’s identifier using ListDistributions
// or GetDistribution. If the origin request policy is not attached to a cache
// behavior, you can get the identifier using ListOriginRequestPolicies.
//
//    // Example sending a request using GetOriginRequestPolicyConfigRequest.
//    req := client.GetOriginRequestPolicyConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicyConfig
func (c *Client) GetOriginRequestPolicyConfigRequest(input *GetOriginRequestPolicyConfigInput) GetOriginRequestPolicyConfigRequest {
	op := &aws.Operation{
		Name:       opGetOriginRequestPolicyConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-05-31/origin-request-policy/{Id}/config",
	}

	if input == nil {
		input = &GetOriginRequestPolicyConfigInput{}
	}

	req := c.newRequest(op, input, &GetOriginRequestPolicyConfigOutput{})

	return GetOriginRequestPolicyConfigRequest{Request: req, Input: input, Copy: c.GetOriginRequestPolicyConfigRequest}
}

// GetOriginRequestPolicyConfigRequest is the request type for the
// GetOriginRequestPolicyConfig API operation.
type GetOriginRequestPolicyConfigRequest struct {
	*aws.Request
	Input *GetOriginRequestPolicyConfigInput
	Copy  func(*GetOriginRequestPolicyConfigInput) GetOriginRequestPolicyConfigRequest
}

// Send marshals and sends the GetOriginRequestPolicyConfig API request.
func (r GetOriginRequestPolicyConfigRequest) Send(ctx context.Context) (*GetOriginRequestPolicyConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetOriginRequestPolicyConfigResponse{
		GetOriginRequestPolicyConfigOutput: r.Request.Data.(*GetOriginRequestPolicyConfigOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetOriginRequestPolicyConfigResponse is the response type for the
// GetOriginRequestPolicyConfig API operation.
type GetOriginRequestPolicyConfigResponse struct {
	*GetOriginRequestPolicyConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetOriginRequestPolicyConfig request.
func (r *GetOriginRequestPolicyConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
