// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package cloudfrontiface provides an interface to enable mocking the Amazon CloudFront service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package cloudfrontiface

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront"
)

// ClientAPI provides an interface to enable mocking the
// cloudfront.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // CloudFront.
//    func myFunc(svc cloudfrontiface.ClientAPI) bool {
//        // Make svc.CreateCachePolicy request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := cloudfront.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        cloudfrontiface.ClientPI
//    }
//    func (m *mockClientClient) CreateCachePolicy(input *cloudfront.CreateCachePolicyInput) (*cloudfront.CreateCachePolicyOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateCachePolicyRequest(*cloudfront.CreateCachePolicyInput) cloudfront.CreateCachePolicyRequest

	CreateCloudFrontOriginAccessIdentityRequest(*cloudfront.CreateCloudFrontOriginAccessIdentityInput) cloudfront.CreateCloudFrontOriginAccessIdentityRequest

	CreateDistributionRequest(*cloudfront.CreateDistributionInput) cloudfront.CreateDistributionRequest

	CreateDistributionWithTagsRequest(*cloudfront.CreateDistributionWithTagsInput) cloudfront.CreateDistributionWithTagsRequest

	CreateFieldLevelEncryptionConfigRequest(*cloudfront.CreateFieldLevelEncryptionConfigInput) cloudfront.CreateFieldLevelEncryptionConfigRequest

	CreateFieldLevelEncryptionProfileRequest(*cloudfront.CreateFieldLevelEncryptionProfileInput) cloudfront.CreateFieldLevelEncryptionProfileRequest

	CreateInvalidationRequest(*cloudfront.CreateInvalidationInput) cloudfront.CreateInvalidationRequest

	CreateOriginRequestPolicyRequest(*cloudfront.CreateOriginRequestPolicyInput) cloudfront.CreateOriginRequestPolicyRequest

	CreatePublicKeyRequest(*cloudfront.CreatePublicKeyInput) cloudfront.CreatePublicKeyRequest

	CreateStreamingDistributionRequest(*cloudfront.CreateStreamingDistributionInput) cloudfront.CreateStreamingDistributionRequest

	CreateStreamingDistributionWithTagsRequest(*cloudfront.CreateStreamingDistributionWithTagsInput) cloudfront.CreateStreamingDistributionWithTagsRequest

	DeleteCachePolicyRequest(*cloudfront.DeleteCachePolicyInput) cloudfront.DeleteCachePolicyRequest

	DeleteCloudFrontOriginAccessIdentityRequest(*cloudfront.DeleteCloudFrontOriginAccessIdentityInput) cloudfront.DeleteCloudFrontOriginAccessIdentityRequest

	DeleteDistributionRequest(*cloudfront.DeleteDistributionInput) cloudfront.DeleteDistributionRequest

	DeleteFieldLevelEncryptionConfigRequest(*cloudfront.DeleteFieldLevelEncryptionConfigInput) cloudfront.DeleteFieldLevelEncryptionConfigRequest

	DeleteFieldLevelEncryptionProfileRequest(*cloudfront.DeleteFieldLevelEncryptionProfileInput) cloudfront.DeleteFieldLevelEncryptionProfileRequest

	DeleteOriginRequestPolicyRequest(*cloudfront.DeleteOriginRequestPolicyInput) cloudfront.DeleteOriginRequestPolicyRequest

	DeletePublicKeyRequest(*cloudfront.DeletePublicKeyInput) cloudfront.DeletePublicKeyRequest

	DeleteStreamingDistributionRequest(*cloudfront.DeleteStreamingDistributionInput) cloudfront.DeleteStreamingDistributionRequest

	GetCachePolicyRequest(*cloudfront.GetCachePolicyInput) cloudfront.GetCachePolicyRequest

	GetCachePolicyConfigRequest(*cloudfront.GetCachePolicyConfigInput) cloudfront.GetCachePolicyConfigRequest

	GetCloudFrontOriginAccessIdentityRequest(*cloudfront.GetCloudFrontOriginAccessIdentityInput) cloudfront.GetCloudFrontOriginAccessIdentityRequest

	GetCloudFrontOriginAccessIdentityConfigRequest(*cloudfront.GetCloudFrontOriginAccessIdentityConfigInput) cloudfront.GetCloudFrontOriginAccessIdentityConfigRequest

	GetDistributionRequest(*cloudfront.GetDistributionInput) cloudfront.GetDistributionRequest

	GetDistributionConfigRequest(*cloudfront.GetDistributionConfigInput) cloudfront.GetDistributionConfigRequest

	GetFieldLevelEncryptionRequest(*cloudfront.GetFieldLevelEncryptionInput) cloudfront.GetFieldLevelEncryptionRequest

	GetFieldLevelEncryptionConfigRequest(*cloudfront.GetFieldLevelEncryptionConfigInput) cloudfront.GetFieldLevelEncryptionConfigRequest

	GetFieldLevelEncryptionProfileRequest(*cloudfront.GetFieldLevelEncryptionProfileInput) cloudfront.GetFieldLevelEncryptionProfileRequest

	GetFieldLevelEncryptionProfileConfigRequest(*cloudfront.GetFieldLevelEncryptionProfileConfigInput) cloudfront.GetFieldLevelEncryptionProfileConfigRequest

	GetInvalidationRequest(*cloudfront.GetInvalidationInput) cloudfront.GetInvalidationRequest

	GetOriginRequestPolicyRequest(*cloudfront.GetOriginRequestPolicyInput) cloudfront.GetOriginRequestPolicyRequest

	GetOriginRequestPolicyConfigRequest(*cloudfront.GetOriginRequestPolicyConfigInput) cloudfront.GetOriginRequestPolicyConfigRequest

	GetPublicKeyRequest(*cloudfront.GetPublicKeyInput) cloudfront.GetPublicKeyRequest

	GetPublicKeyConfigRequest(*cloudfront.GetPublicKeyConfigInput) cloudfront.GetPublicKeyConfigRequest

	GetStreamingDistributionRequest(*cloudfront.GetStreamingDistributionInput) cloudfront.GetStreamingDistributionRequest

	GetStreamingDistributionConfigRequest(*cloudfront.GetStreamingDistributionConfigInput) cloudfront.GetStreamingDistributionConfigRequest

	ListCachePoliciesRequest(*cloudfront.ListCachePoliciesInput) cloudfront.ListCachePoliciesRequest

	ListCloudFrontOriginAccessIdentitiesRequest(*cloudfront.ListCloudFrontOriginAccessIdentitiesInput) cloudfront.ListCloudFrontOriginAccessIdentitiesRequest

	ListDistributionsRequest(*cloudfront.ListDistributionsInput) cloudfront.ListDistributionsRequest

	ListDistributionsByCachePolicyIdRequest(*cloudfront.ListDistributionsByCachePolicyIdInput) cloudfront.ListDistributionsByCachePolicyIdRequest

	ListDistributionsByOriginRequestPolicyIdRequest(*cloudfront.ListDistributionsByOriginRequestPolicyIdInput) cloudfront.ListDistributionsByOriginRequestPolicyIdRequest

	ListDistributionsByWebACLIdRequest(*cloudfront.ListDistributionsByWebACLIdInput) cloudfront.ListDistributionsByWebACLIdRequest

	ListFieldLevelEncryptionConfigsRequest(*cloudfront.ListFieldLevelEncryptionConfigsInput) cloudfront.ListFieldLevelEncryptionConfigsRequest

	ListFieldLevelEncryptionProfilesRequest(*cloudfront.ListFieldLevelEncryptionProfilesInput) cloudfront.ListFieldLevelEncryptionProfilesRequest

	ListInvalidationsRequest(*cloudfront.ListInvalidationsInput) cloudfront.ListInvalidationsRequest

	ListOriginRequestPoliciesRequest(*cloudfront.ListOriginRequestPoliciesInput) cloudfront.ListOriginRequestPoliciesRequest

	ListPublicKeysRequest(*cloudfront.ListPublicKeysInput) cloudfront.ListPublicKeysRequest

	ListStreamingDistributionsRequest(*cloudfront.ListStreamingDistributionsInput) cloudfront.ListStreamingDistributionsRequest

	ListTagsForResourceRequest(*cloudfront.ListTagsForResourceInput) cloudfront.ListTagsForResourceRequest

	TagResourceRequest(*cloudfront.TagResourceInput) cloudfront.TagResourceRequest

	UntagResourceRequest(*cloudfront.UntagResourceInput) cloudfront.UntagResourceRequest

	UpdateCachePolicyRequest(*cloudfront.UpdateCachePolicyInput) cloudfront.UpdateCachePolicyRequest

	UpdateCloudFrontOriginAccessIdentityRequest(*cloudfront.UpdateCloudFrontOriginAccessIdentityInput) cloudfront.UpdateCloudFrontOriginAccessIdentityRequest

	UpdateDistributionRequest(*cloudfront.UpdateDistributionInput) cloudfront.UpdateDistributionRequest

	UpdateFieldLevelEncryptionConfigRequest(*cloudfront.UpdateFieldLevelEncryptionConfigInput) cloudfront.UpdateFieldLevelEncryptionConfigRequest

	UpdateFieldLevelEncryptionProfileRequest(*cloudfront.UpdateFieldLevelEncryptionProfileInput) cloudfront.UpdateFieldLevelEncryptionProfileRequest

	UpdateOriginRequestPolicyRequest(*cloudfront.UpdateOriginRequestPolicyInput) cloudfront.UpdateOriginRequestPolicyRequest

	UpdatePublicKeyRequest(*cloudfront.UpdatePublicKeyInput) cloudfront.UpdatePublicKeyRequest

	UpdateStreamingDistributionRequest(*cloudfront.UpdateStreamingDistributionInput) cloudfront.UpdateStreamingDistributionRequest

	WaitUntilDistributionDeployed(context.Context, *cloudfront.GetDistributionInput, ...aws.WaiterOption) error

	WaitUntilInvalidationCompleted(context.Context, *cloudfront.GetInvalidationInput, ...aws.WaiterOption) error

	WaitUntilStreamingDistributionDeployed(context.Context, *cloudfront.GetStreamingDistributionInput, ...aws.WaiterOption) error
}

var _ ClientAPI = (*cloudfront.Client)(nil)
