// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudhsmv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateHsmInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone where you are creating the HSM. To find the cluster's
	// Availability Zones, use DescribeClusters.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `type:"string" required:"true"`

	// The identifier (ID) of the HSM's cluster. To find the cluster ID, use DescribeClusters.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The HSM's IP address. If you specify an IP address, use an available address
	// from the subnet that maps to the Availability Zone where you are creating
	// the HSM. If you don't specify an IP address, one is chosen for you from that
	// subnet.
	IpAddress *string `type:"string"`
}

// String returns the string representation
func (s CreateHsmInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHsmInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateHsmInput"}

	if s.AvailabilityZone == nil {
		invalidParams.Add(aws.NewErrParamRequired("AvailabilityZone"))
	}

	if s.ClusterId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateHsmOutput struct {
	_ struct{} `type:"structure"`

	// Information about the HSM that was created.
	Hsm *Hsm `type:"structure"`
}

// String returns the string representation
func (s CreateHsmOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateHsm = "CreateHsm"

// CreateHsmRequest returns a request value for making API operation for
// AWS CloudHSM V2.
//
// Creates a new hardware security module (HSM) in the specified AWS CloudHSM
// cluster.
//
//    // Example sending a request using CreateHsmRequest.
//    req := client.CreateHsmRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsmv2-2017-04-28/CreateHsm
func (c *Client) CreateHsmRequest(input *CreateHsmInput) CreateHsmRequest {
	op := &aws.Operation{
		Name:       opCreateHsm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHsmInput{}
	}

	req := c.newRequest(op, input, &CreateHsmOutput{})

	return CreateHsmRequest{Request: req, Input: input, Copy: c.CreateHsmRequest}
}

// CreateHsmRequest is the request type for the
// CreateHsm API operation.
type CreateHsmRequest struct {
	*aws.Request
	Input *CreateHsmInput
	Copy  func(*CreateHsmInput) CreateHsmRequest
}

// Send marshals and sends the CreateHsm API request.
func (r CreateHsmRequest) Send(ctx context.Context) (*CreateHsmResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateHsmResponse{
		CreateHsmOutput: r.Request.Data.(*CreateHsmOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateHsmResponse is the response type for the
// CreateHsm API operation.
type CreateHsmResponse struct {
	*CreateHsmOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateHsm request.
func (r *CreateHsmResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
