// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Container for the parameters to the DescribeAnalysisSchemes operation. Specifies
// the name of the domain you want to describe. To limit the response to particular
// analysis schemes, specify the names of the analysis schemes you want to describe.
// To show the active configuration and exclude any pending changes, set the
// Deployed option to true.
type DescribeAnalysisSchemesInput struct {
	_ struct{} `type:"structure"`

	// The analysis schemes you want to describe.
	AnalysisSchemeNames []string `type:"list"`

	// Whether to display the deployed configuration (true) or include any pending
	// changes (false). Defaults to false.
	Deployed *bool `type:"boolean"`

	// The name of the domain you want to describe.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAnalysisSchemesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAnalysisSchemesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAnalysisSchemesInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DescribeAnalysisSchemes request. Contains the analysis schemes
// configured for the domain specified in the request.
type DescribeAnalysisSchemesOutput struct {
	_ struct{} `type:"structure"`

	// The analysis scheme descriptions.
	//
	// AnalysisSchemes is a required field
	AnalysisSchemes []AnalysisSchemeStatus `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeAnalysisSchemesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAnalysisSchemes = "DescribeAnalysisSchemes"

// DescribeAnalysisSchemesRequest returns a request value for making API operation for
// Amazon CloudSearch.
//
// Gets the analysis schemes configured for a domain. An analysis scheme defines
// language-specific text processing options for a text field. Can be limited
// to specific analysis schemes by name. By default, shows all analysis schemes
// and includes any pending changes to the configuration. Set the Deployed option
// to true to show the active configuration and exclude pending changes. For
// more information, see Configuring Analysis Schemes (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html)
// in the Amazon CloudSearch Developer Guide.
//
//    // Example sending a request using DescribeAnalysisSchemesRequest.
//    req := client.DescribeAnalysisSchemesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeAnalysisSchemesRequest(input *DescribeAnalysisSchemesInput) DescribeAnalysisSchemesRequest {
	op := &aws.Operation{
		Name:       opDescribeAnalysisSchemes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAnalysisSchemesInput{}
	}

	req := c.newRequest(op, input, &DescribeAnalysisSchemesOutput{})

	return DescribeAnalysisSchemesRequest{Request: req, Input: input, Copy: c.DescribeAnalysisSchemesRequest}
}

// DescribeAnalysisSchemesRequest is the request type for the
// DescribeAnalysisSchemes API operation.
type DescribeAnalysisSchemesRequest struct {
	*aws.Request
	Input *DescribeAnalysisSchemesInput
	Copy  func(*DescribeAnalysisSchemesInput) DescribeAnalysisSchemesRequest
}

// Send marshals and sends the DescribeAnalysisSchemes API request.
func (r DescribeAnalysisSchemesRequest) Send(ctx context.Context) (*DescribeAnalysisSchemesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAnalysisSchemesResponse{
		DescribeAnalysisSchemesOutput: r.Request.Data.(*DescribeAnalysisSchemesOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAnalysisSchemesResponse is the response type for the
// DescribeAnalysisSchemes API operation.
type DescribeAnalysisSchemesResponse struct {
	*DescribeAnalysisSchemesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAnalysisSchemes request.
func (r *DescribeAnalysisSchemesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
