// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Container for the parameters to the DescribeDomains operation. By default
// shows the status of all domains. To restrict the response to particular domains,
// specify the names of the domains you want to describe.
type DescribeDomainsInput struct {
	_ struct{} `type:"structure"`

	// The names of the domains you want to include in the response.
	DomainNames []string `type:"list"`
}

// String returns the string representation
func (s DescribeDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// The result of a DescribeDomains request. Contains the status of the domains
// specified in the request or all domains owned by the account.
type DescribeDomainsOutput struct {
	_ struct{} `type:"structure"`

	// A list that contains the status of each requested domain.
	//
	// DomainStatusList is a required field
	DomainStatusList []DomainStatus `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDomains = "DescribeDomains"

// DescribeDomainsRequest returns a request value for making API operation for
// Amazon CloudSearch.
//
// Gets information about the search domains owned by this account. Can be limited
// to specific domains. Shows all domains by default. To get the number of searchable
// documents in a domain, use the console or submit a matchall request to your
// domain's search endpoint: q=matchall&q.parser=structured&size=0.
// For more information, see Getting Information about a Search Domain (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html)
// in the Amazon CloudSearch Developer Guide.
//
//    // Example sending a request using DescribeDomainsRequest.
//    req := client.DescribeDomainsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeDomainsRequest(input *DescribeDomainsInput) DescribeDomainsRequest {
	op := &aws.Operation{
		Name:       opDescribeDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDomainsInput{}
	}

	req := c.newRequest(op, input, &DescribeDomainsOutput{})

	return DescribeDomainsRequest{Request: req, Input: input, Copy: c.DescribeDomainsRequest}
}

// DescribeDomainsRequest is the request type for the
// DescribeDomains API operation.
type DescribeDomainsRequest struct {
	*aws.Request
	Input *DescribeDomainsInput
	Copy  func(*DescribeDomainsInput) DescribeDomainsRequest
}

// Send marshals and sends the DescribeDomains API request.
func (r DescribeDomainsRequest) Send(ctx context.Context) (*DescribeDomainsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDomainsResponse{
		DescribeDomainsOutput: r.Request.Data.(*DescribeDomainsOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDomainsResponse is the response type for the
// DescribeDomains API operation.
type DescribeDomainsResponse struct {
	*DescribeDomainsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDomains request.
func (r *DescribeDomainsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
