// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Container for the parameters to the DescribeScalingParameters operation.
// Specifies the name of the domain you want to describe.
type DescribeScalingParametersInput struct {
	_ struct{} `type:"structure"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeScalingParametersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingParametersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeScalingParametersInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DescribeScalingParameters request. Contains the scaling parameters
// configured for the domain specified in the request.
type DescribeScalingParametersOutput struct {
	_ struct{} `type:"structure"`

	// The status and configuration of a search domain's scaling parameters.
	//
	// ScalingParameters is a required field
	ScalingParameters *ScalingParametersStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeScalingParametersOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeScalingParameters = "DescribeScalingParameters"

// DescribeScalingParametersRequest returns a request value for making API operation for
// Amazon CloudSearch.
//
// Gets the scaling parameters configured for a domain. A domain's scaling parameters
// specify the desired search instance type and replication count. For more
// information, see Configuring Scaling Options (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html)
// in the Amazon CloudSearch Developer Guide.
//
//    // Example sending a request using DescribeScalingParametersRequest.
//    req := client.DescribeScalingParametersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeScalingParametersRequest(input *DescribeScalingParametersInput) DescribeScalingParametersRequest {
	op := &aws.Operation{
		Name:       opDescribeScalingParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScalingParametersInput{}
	}

	req := c.newRequest(op, input, &DescribeScalingParametersOutput{})

	return DescribeScalingParametersRequest{Request: req, Input: input, Copy: c.DescribeScalingParametersRequest}
}

// DescribeScalingParametersRequest is the request type for the
// DescribeScalingParameters API operation.
type DescribeScalingParametersRequest struct {
	*aws.Request
	Input *DescribeScalingParametersInput
	Copy  func(*DescribeScalingParametersInput) DescribeScalingParametersRequest
}

// Send marshals and sends the DescribeScalingParameters API request.
func (r DescribeScalingParametersRequest) Send(ctx context.Context) (*DescribeScalingParametersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeScalingParametersResponse{
		DescribeScalingParametersOutput: r.Request.Data.(*DescribeScalingParametersOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeScalingParametersResponse is the response type for the
// DescribeScalingParameters API operation.
type DescribeScalingParametersResponse struct {
	*DescribeScalingParametersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeScalingParameters request.
func (r *DescribeScalingParametersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
