// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Container for the parameters to the IndexDocuments operation. Specifies the
// name of the domain you want to re-index.
type IndexDocumentsInput struct {
	_ struct{} `type:"structure"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s IndexDocumentsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IndexDocumentsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IndexDocumentsInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of an IndexDocuments request. Contains the status of the indexing
// operation, including the fields being indexed.
type IndexDocumentsOutput struct {
	_ struct{} `type:"structure"`

	// The names of the fields that are currently being indexed.
	FieldNames []string `type:"list"`
}

// String returns the string representation
func (s IndexDocumentsOutput) String() string {
	return awsutil.Prettify(s)
}

const opIndexDocuments = "IndexDocuments"

// IndexDocumentsRequest returns a request value for making API operation for
// Amazon CloudSearch.
//
// Tells the search domain to start indexing its documents using the latest
// indexing options. This operation must be invoked to activate options whose
// OptionStatus is RequiresIndexDocuments.
//
//    // Example sending a request using IndexDocumentsRequest.
//    req := client.IndexDocumentsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) IndexDocumentsRequest(input *IndexDocumentsInput) IndexDocumentsRequest {
	op := &aws.Operation{
		Name:       opIndexDocuments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IndexDocumentsInput{}
	}

	req := c.newRequest(op, input, &IndexDocumentsOutput{})

	return IndexDocumentsRequest{Request: req, Input: input, Copy: c.IndexDocumentsRequest}
}

// IndexDocumentsRequest is the request type for the
// IndexDocuments API operation.
type IndexDocumentsRequest struct {
	*aws.Request
	Input *IndexDocumentsInput
	Copy  func(*IndexDocumentsInput) IndexDocumentsRequest
}

// Send marshals and sends the IndexDocuments API request.
func (r IndexDocumentsRequest) Send(ctx context.Context) (*IndexDocumentsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &IndexDocumentsResponse{
		IndexDocumentsOutput: r.Request.Data.(*IndexDocumentsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// IndexDocumentsResponse is the response type for the
// IndexDocuments API operation.
type IndexDocumentsResponse struct {
	*IndexDocumentsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// IndexDocuments request.
func (r *IndexDocumentsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
