// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListDomainNamesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListDomainNamesInput) String() string {
	return awsutil.Prettify(s)
}

// The result of a ListDomainNames request. Contains a list of the domains owned
// by an account.
type ListDomainNamesOutput struct {
	_ struct{} `type:"structure"`

	// The names of the search domains owned by an account.
	DomainNames map[string]string `type:"map"`
}

// String returns the string representation
func (s ListDomainNamesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListDomainNames = "ListDomainNames"

// ListDomainNamesRequest returns a request value for making API operation for
// Amazon CloudSearch.
//
// Lists all search domains owned by an account.
//
//    // Example sending a request using ListDomainNamesRequest.
//    req := client.ListDomainNamesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListDomainNamesRequest(input *ListDomainNamesInput) ListDomainNamesRequest {
	op := &aws.Operation{
		Name:       opListDomainNames,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDomainNamesInput{}
	}

	req := c.newRequest(op, input, &ListDomainNamesOutput{})

	return ListDomainNamesRequest{Request: req, Input: input, Copy: c.ListDomainNamesRequest}
}

// ListDomainNamesRequest is the request type for the
// ListDomainNames API operation.
type ListDomainNamesRequest struct {
	*aws.Request
	Input *ListDomainNamesInput
	Copy  func(*ListDomainNamesInput) ListDomainNamesRequest
}

// Send marshals and sends the ListDomainNames API request.
func (r ListDomainNamesRequest) Send(ctx context.Context) (*ListDomainNamesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDomainNamesResponse{
		ListDomainNamesOutput: r.Request.Data.(*ListDomainNamesOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListDomainNamesResponse is the response type for the
// ListDomainNames API operation.
type ListDomainNamesResponse struct {
	*ListDomainNamesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDomainNames request.
func (r *ListDomainNamesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
