// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearchdomain

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Container for the parameters to the Suggest request.
type SuggestInput struct {
	_ struct{} `type:"structure"`

	// Specifies the string for which you want to get suggestions.
	//
	// Query is a required field
	Query *string `location:"querystring" locationName:"q" type:"string" required:"true"`

	// Specifies the maximum number of suggestions to return.
	Size *int64 `location:"querystring" locationName:"size" type:"long"`

	// Specifies the name of the suggester to use to find suggested matches.
	//
	// Suggester is a required field
	Suggester *string `location:"querystring" locationName:"suggester" type:"string" required:"true"`
}

// String returns the string representation
func (s SuggestInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SuggestInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SuggestInput"}

	if s.Query == nil {
		invalidParams.Add(aws.NewErrParamRequired("Query"))
	}

	if s.Suggester == nil {
		invalidParams.Add(aws.NewErrParamRequired("Suggester"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SuggestInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Query != nil {
		v := *s.Query

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "q", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Size != nil {
		v := *s.Size

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "size", protocol.Int64Value(v), metadata)
	}
	if s.Suggester != nil {
		v := *s.Suggester

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "suggester", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains the response to a Suggest request.
type SuggestOutput struct {
	_ struct{} `type:"structure"`

	// The status of a SuggestRequest. Contains the resource ID (rid) and how long
	// it took to process the request (timems).
	Status *SuggestStatus `locationName:"status" type:"structure"`

	// Container for the matching search suggestion information.
	Suggest *SuggestModel `locationName:"suggest" type:"structure"`
}

// String returns the string representation
func (s SuggestOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SuggestOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "status", v, metadata)
	}
	if s.Suggest != nil {
		v := s.Suggest

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "suggest", v, metadata)
	}
	return nil
}

const opSuggest = "Suggest"

// SuggestRequest returns a request value for making API operation for
// Amazon CloudSearch Domain.
//
// Retrieves autocomplete suggestions for a partial query string. You can use
// suggestions enable you to display likely matches before users finish typing.
// In Amazon CloudSearch, suggestions are based on the contents of a particular
// text field. When you request suggestions, Amazon CloudSearch finds all of
// the documents whose values in the suggester field start with the specified
// query string. The beginning of the field must match the query string to be
// considered a match.
//
// For more information about configuring suggesters and retrieving suggestions,
// see Getting Suggestions (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html)
// in the Amazon CloudSearch Developer Guide.
//
// The endpoint for submitting Suggest requests is domain-specific. You submit
// suggest requests to a domain's search endpoint. To get the search endpoint
// for your domain, use the Amazon CloudSearch configuration service DescribeDomains
// action. A domain's endpoints are also displayed on the domain dashboard in
// the Amazon CloudSearch console.
//
//    // Example sending a request using SuggestRequest.
//    req := client.SuggestRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) SuggestRequest(input *SuggestInput) SuggestRequest {
	op := &aws.Operation{
		Name:       opSuggest,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-01-01/suggest?format=sdk&pretty=true",
	}

	if input == nil {
		input = &SuggestInput{}
	}

	req := c.newRequest(op, input, &SuggestOutput{})

	return SuggestRequest{Request: req, Input: input, Copy: c.SuggestRequest}
}

// SuggestRequest is the request type for the
// Suggest API operation.
type SuggestRequest struct {
	*aws.Request
	Input *SuggestInput
	Copy  func(*SuggestInput) SuggestRequest
}

// Send marshals and sends the Suggest API request.
func (r SuggestRequest) Send(ctx context.Context) (*SuggestResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SuggestResponse{
		SuggestOutput: r.Request.Data.(*SuggestOutput),
		response:      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SuggestResponse is the response type for the
// Suggest API operation.
type SuggestResponse struct {
	*SuggestOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// Suggest request.
func (r *SuggestResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
